
/* heading.h */

#ifndef _HEADING_H
#define _HEADING_H

#define YY_NO_UNPUT

using namespace std;

#include <iostream>
#include <stdio.h>
#include <stdint.h>
#include <string>

#include "compact-string.h"
#include "relalgebra.h"

class gg_node
{
	private:
		int64_t uniqueId;
	public:
		inline int64_t getUniqueId() const { return uniqueId; }

		virtual string toString() const = 0;

		gg_node();
};

// Forward definition of base datatype classes
class gg_datatype_OutputSpec_base;
class gg_datatype_SearchResult_base;
class gg_datatype_Argument_base;

class gg_datatype_OutputSpec_base : public gg_node
{
	public:
		virtual void output_formatted(ostream &os) const = 0;
		gg_datatype_OutputSpec_base() : gg_node() { }
};

class gg_datatype_OutputSpec_type1 : public gg_datatype_OutputSpec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_SearchResult_base* subtree_r;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_OutputSpec_base
		virtual void output_formatted(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_OutputSpec_base

		// internal operations
		// constructor
		gg_datatype_OutputSpec_type1(gg_datatype_SearchResult_base* const &r);
};

class gg_datatype_OutputSpec_type2 : public gg_datatype_OutputSpec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_SearchResult_base* subtree_r;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_OutputSpec_base
		virtual void output_formatted(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_OutputSpec_base

		// internal operations
		// constructor
		gg_datatype_OutputSpec_type2(gg_datatype_SearchResult_base* const &r);
};

class gg_datatype_OutputSpec_type3 : public gg_datatype_OutputSpec_base
{
	public:
		// abstract syntax tree representation
		gg_datatype_SearchResult_base* subtree_r;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_OutputSpec_base
		virtual void output_formatted(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_OutputSpec_base

		// internal operations
		// constructor
		gg_datatype_OutputSpec_type3(gg_datatype_SearchResult_base* const &r);
};

class gg_datatype_OutputSpec_type4 : public gg_datatype_OutputSpec_base
{
	public:
		// abstract syntax tree representation
		vector<gg_datatype_SearchResult_base*> subtree_rs;

		// local variables
		rel_algebra_node local_satAnswerIndices;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_OutputSpec_base
		virtual void output_formatted(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_OutputSpec_base

		// internal operations
		// constructor
		gg_datatype_OutputSpec_type4(vector<gg_datatype_SearchResult_base*> const &rs);
};

class gg_datatype_OutputSpec_type5 : public gg_datatype_OutputSpec_base
{
	public:
		// abstract syntax tree representation
		vector<gg_datatype_SearchResult_base*> subtree_gr_rs;
		vector<gg_datatype_SearchResult_base*> subtree_st_rs;
		vector<gg_datatype_SearchResult_base*> subtree_pr_rs;

		// local variables
		rel_algebra_node local_st_satAnswerIndices;
		rel_algebra_node local_pr_satAnswerIndices;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_OutputSpec_base
		virtual void output_formatted(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_OutputSpec_base

		// internal operations
		// constructor
		gg_datatype_OutputSpec_type5(vector<gg_datatype_SearchResult_base*> const &gr_rs, vector<gg_datatype_SearchResult_base*> const &st_rs, vector<gg_datatype_SearchResult_base*> const &pr_rs);
};

class gg_datatype_SearchResult_base : public gg_node
{
	public:
		rel_algebra_node local_isSat;
		virtual void output_answer(ostream &os) const = 0;
		gg_datatype_SearchResult_base() : gg_node() { }
};

class gg_datatype_SearchResult_type1 : public gg_datatype_SearchResult_base
{
	public:
		// abstract syntax tree representation
		vector<gg_datatype_Argument_base*> subtree_args;

		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_SearchResult_base
		virtual void output_answer(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_SearchResult_base

		// internal operations
		// constructor
		gg_datatype_SearchResult_type1(vector<gg_datatype_Argument_base*> const &args);
};

class gg_datatype_SearchResult_type2 : public gg_datatype_SearchResult_base
{
	public:
		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_SearchResult_base
		virtual void output_answer(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_SearchResult_base

		// internal operations
		// constructor
		gg_datatype_SearchResult_type2();
};

class gg_datatype_SearchResult_type3 : public gg_datatype_SearchResult_base
{
	public:
		// local variables

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_SearchResult_base
		virtual void output_answer(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_SearchResult_base

		// internal operations
		// constructor
		gg_datatype_SearchResult_type3();
};

class gg_datatype_Argument_base : public gg_node
{
	public:
		virtual void output_name(ostream &os) const = 0;
		gg_datatype_Argument_base() : gg_node() { }
};

class gg_datatype_Argument_type1 : public gg_datatype_Argument_base
{
	public:
		// abstract syntax tree representation
		compact_string subtree_argId;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Argument_base
		virtual void output_name(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Argument_base

		// internal operations
		// constructor
		gg_datatype_Argument_type1(compact_string const &argId);
};

class gg_datatype_Argument_type2 : public gg_datatype_Argument_base
{
	public:
		// abstract syntax tree representation
		int64_t subtree_argNo;

		// methods inherited from gg_node
		virtual string toString() const;

		// output/fixpoint methods inherited from gg_datatype_Argument_base
		virtual void output_name(ostream &os) const;

		// internal output/fixpoint methods

		// operations inherited from gg_datatype_Argument_base

		// internal operations
		// constructor
		gg_datatype_Argument_type2(int64_t const &argNo);
};


#endif

