
#include <algorithm>

#include "heading.h"
#include "generalized-filters.h"
#include "macros.h"
#include "assignment-manager.h"

static int64_t lastAvailableUniqueId = 1;

static unordered_map<compact_string, unordered_map<compact_string, int64_t, compact_string_hash>, compact_string_hash> nameToIntegerMap;
static unordered_map<compact_string, vector<compact_string>, compact_string_hash> integerToNameMap;

int64_t mapToInt(compact_string category, compact_string name)
{
	auto categoryIt = nameToIntegerMap.find(category);
	if (categoryIt == nameToIntegerMap.end())
	{
		nameToIntegerMap[category] = unordered_map<compact_string, int64_t, compact_string_hash>();
		integerToNameMap[category] = vector<compact_string>();
		categoryIt = nameToIntegerMap.find(category);
	}

	auto nameIt = categoryIt->second.find(name);
	if (nameIt != categoryIt->second.end())
		return nameIt->second;

	int64_t result = categoryIt->second.size() + 1;
	categoryIt->second[name] = result;
	integerToNameMap[category].push_back(name);
	return result;
}

compact_string mapFromInt(compact_string category, int64_t nameId)
{
	auto categoryIt = integerToNameMap.find(category);

	assert(categoryIt != integerToNameMap.end());
	assert(nameId >= 1);
	assert(size_t(nameId) <= categoryIt->second.size());

	return categoryIt->second[nameId - 1];
}

gg_node::gg_node()
{
	uniqueId = lastAvailableUniqueId;
	lastAvailableUniqueId++;
}


void gg_datatype_OutputSpec_type1::output_formatted(ostream &os) const
{
	rel_algebra_node temp_7 = subtree_r->local_isSat;
	if ((!rel_algebra::isEmpty(temp_7)))
	{
		os << "YES";
	}
	else
	{
		os << "NO";
	}
	os << "\n";
}

string gg_datatype_OutputSpec_type1::toString() const
{
	string result = "";
	result += "brave";
	result += subtree_r->toString();
	return result;
}

gg_datatype_OutputSpec_type1::gg_datatype_OutputSpec_type1(gg_datatype_SearchResult_base* const &r) : gg_datatype_OutputSpec_base(), subtree_r(r)
{
}

void gg_datatype_OutputSpec_type2::output_formatted(ostream &os) const
{
	rel_algebra_node temp_29 = subtree_r->local_isSat;
	if ((!rel_algebra::isEmpty(temp_29)))
	{
		os << "NO";
	}
	else
	{
		os << "YES";
	}
	os << "\n";
}

string gg_datatype_OutputSpec_type2::toString() const
{
	string result = "";
	result += "skeptical";
	result += subtree_r->toString();
	return result;
}

gg_datatype_OutputSpec_type2::gg_datatype_OutputSpec_type2(gg_datatype_SearchResult_base* const &r) : gg_datatype_OutputSpec_base(), subtree_r(r)
{
}

void gg_datatype_OutputSpec_type3::output_formatted(ostream &os) const
{
	rel_algebra_node temp_51 = subtree_r->local_isSat;
	if ((!rel_algebra::isEmpty(temp_51)))
	{
		subtree_r->output_answer(os);
	}
	else
	{
		os << "NO";
	}
	os << "\n";
}

string gg_datatype_OutputSpec_type3::toString() const
{
	string result = "";
	result += "search";
	result += subtree_r->toString();
	return result;
}

gg_datatype_OutputSpec_type3::gg_datatype_OutputSpec_type3(gg_datatype_SearchResult_base* const &r) : gg_datatype_OutputSpec_base(), subtree_r(r)
{
}

void gg_datatype_OutputSpec_type4::output_formatted(ostream &os) const
{
	os << "[";
	rel_algebra_node temp_101 = local_satAnswerIndices;bool initial_index = true;
	for (auto local_index = rel_algebra::getUnitIterator(temp_101); !local_index.atEnd(); ++local_index)
	{
		if (!initial_index)
		{
			os << ",";
		}
		initial_index = false;
		int64_t temp_94 = 0;
		int64_t temp_96 = local_index[temp_94];
		subtree_rs[temp_96]->output_answer(os);
	}
	os << "]\n";
}

string gg_datatype_OutputSpec_type4::toString() const
{
	string result = "";
	result += "enumerate";
	for (auto it = subtree_rs.begin(); it != subtree_rs.end(); ++it)
		result += (*it)->toString();
	return result;
}

gg_datatype_OutputSpec_type4::gg_datatype_OutputSpec_type4(vector<gg_datatype_SearchResult_base*> const &rs) : gg_datatype_OutputSpec_base(), subtree_rs(rs)
{
	rel_algebra_node temp_89 = rel_algebra::trueTable();
	rel_algebra_node temp_74 = rel_algebra::trueTable();
	int64_t temp_72 = 0;
	int64_t temp_73 = 0;
	rel_algebra_node temp_78 = rel_algebra::filterGreaterThanOrEqualTo(temp_72, temp_73, temp_74);
	temp_89 = rel_algebra::join(temp_89, temp_78);
	rel_algebra_node temp_84 = rel_algebra::trueTable();
	int64_t temp_79 = 0;
	int64_t temp_81 = subtree_rs.size();
	int64_t temp_82 = 1;
	int64_t temp_83 = temp_81 - temp_82;
	rel_algebra_node temp_88 = rel_algebra::filterLessThan(temp_79, temp_83, temp_84);
	temp_89 = rel_algebra::join(temp_89, temp_88);
	local_satAnswerIndices = temp_89;
}

void gg_datatype_OutputSpec_type5::output_formatted(ostream &os) const
{
	os << "[";
	int64_t temp_169 = 0;
	subtree_gr_rs[temp_169]->output_answer(os);
	os << "],";
	os << "[";
	rel_algebra_node temp_186 = local_st_satAnswerIndices;bool initial_st_index = true;
	for (auto local_st_index = rel_algebra::getUnitIterator(temp_186); !local_st_index.atEnd(); ++local_st_index)
	{
		if (!initial_st_index)
		{
			os << ",";
		}
		initial_st_index = false;
		int64_t temp_179 = 0;
		int64_t temp_181 = local_st_index[temp_179];
		subtree_st_rs[temp_181]->output_answer(os);
	}
	os << "],";
	os << "[";
	rel_algebra_node temp_204 = local_pr_satAnswerIndices;bool initial_pr_index = true;
	for (auto local_pr_index = rel_algebra::getUnitIterator(temp_204); !local_pr_index.atEnd(); ++local_pr_index)
	{
		if (!initial_pr_index)
		{
			os << ",";
		}
		initial_pr_index = false;
		int64_t temp_197 = 0;
		int64_t temp_199 = local_pr_index[temp_197];
		subtree_pr_rs[temp_199]->output_answer(os);
	}
	os << "]\n";
}

string gg_datatype_OutputSpec_type5::toString() const
{
	string result = "";
	result += "triathlon";
	for (auto it = subtree_gr_rs.begin(); it != subtree_gr_rs.end(); ++it)
		result += (*it)->toString();
	result += "#";
	for (auto it = subtree_st_rs.begin(); it != subtree_st_rs.end(); ++it)
		result += (*it)->toString();
	result += "#";
	for (auto it = subtree_pr_rs.begin(); it != subtree_pr_rs.end(); ++it)
		result += (*it)->toString();
	return result;
}

gg_datatype_OutputSpec_type5::gg_datatype_OutputSpec_type5(vector<gg_datatype_SearchResult_base*> const &gr_rs, vector<gg_datatype_SearchResult_base*> const &st_rs, vector<gg_datatype_SearchResult_base*> const &pr_rs) : gg_datatype_OutputSpec_base(), subtree_gr_rs(gr_rs), subtree_st_rs(st_rs), subtree_pr_rs(pr_rs)
{
	rel_algebra_node temp_145 = rel_algebra::trueTable();
	rel_algebra_node temp_130 = rel_algebra::trueTable();
	int64_t temp_128 = 0;
	int64_t temp_129 = 0;
	rel_algebra_node temp_134 = rel_algebra::filterGreaterThanOrEqualTo(temp_128, temp_129, temp_130);
	temp_145 = rel_algebra::join(temp_145, temp_134);
	rel_algebra_node temp_140 = rel_algebra::trueTable();
	int64_t temp_135 = 0;
	int64_t temp_137 = subtree_st_rs.size();
	int64_t temp_138 = 1;
	int64_t temp_139 = temp_137 - temp_138;
	rel_algebra_node temp_144 = rel_algebra::filterLessThan(temp_135, temp_139, temp_140);
	temp_145 = rel_algebra::join(temp_145, temp_144);
	local_st_satAnswerIndices = temp_145;

	rel_algebra_node temp_164 = rel_algebra::trueTable();
	rel_algebra_node temp_149 = rel_algebra::trueTable();
	int64_t temp_147 = 0;
	int64_t temp_148 = 0;
	rel_algebra_node temp_153 = rel_algebra::filterGreaterThanOrEqualTo(temp_147, temp_148, temp_149);
	temp_164 = rel_algebra::join(temp_164, temp_153);
	rel_algebra_node temp_159 = rel_algebra::trueTable();
	int64_t temp_154 = 0;
	int64_t temp_156 = subtree_pr_rs.size();
	int64_t temp_157 = 1;
	int64_t temp_158 = temp_156 - temp_157;
	rel_algebra_node temp_163 = rel_algebra::filterLessThan(temp_154, temp_158, temp_159);
	temp_164 = rel_algebra::join(temp_164, temp_163);
	local_pr_satAnswerIndices = temp_164;
}

void gg_datatype_SearchResult_type1::output_answer(ostream &os) const
{
	os << "[";
	rel_algebra_node temp_254 = rel_algebra::trueTable();
	rel_algebra_node temp_241 = rel_algebra::trueTable();
	int64_t temp_239 = 0;
	int64_t temp_240 = 0;
	rel_algebra_node temp_245 = rel_algebra::filterGreaterThanOrEqualTo(temp_239, temp_240, temp_241);
	temp_254 = rel_algebra::join(temp_254, temp_245);
	rel_algebra_node temp_249 = rel_algebra::trueTable();
	int64_t temp_246 = 0;
	int64_t temp_248 = subtree_args.size();
	rel_algebra_node temp_253 = rel_algebra::filterLessThan(temp_246, temp_248, temp_249);
	temp_254 = rel_algebra::join(temp_254, temp_253);bool initial_index = true;
	for (auto local_index = rel_algebra::getUnitIterator(temp_254); !local_index.atEnd(); ++local_index)
	{
		if (!initial_index)
		{
			os << ",";
		}
		initial_index = false;
		int64_t temp_232 = 0;
		int64_t temp_234 = local_index[temp_232];
		subtree_args[temp_234]->output_name(os);
	}
	os << "]";
}

string gg_datatype_SearchResult_type1::toString() const
{
	string result = "";
	result += "SATISFIABLE";
	result += "SAT";
	result += "ANSWER";
	for (auto it = subtree_args.begin(); it != subtree_args.end(); ++it)
		result += (*it)->toString();
	return result;
}

gg_datatype_SearchResult_type1::gg_datatype_SearchResult_type1(vector<gg_datatype_Argument_base*> const &args) : gg_datatype_SearchResult_base(), subtree_args(args)
{
	rel_algebra_node temp_227 = rel_algebra::trueTable();
	local_isSat = temp_227;
}

void gg_datatype_SearchResult_type2::output_answer(ostream &os) const
{
	os << "";
}

string gg_datatype_SearchResult_type2::toString() const
{
	string result = "";
	result += "UNSATISFIABLE";
	result += "UNSAT";
	return result;
}

gg_datatype_SearchResult_type2::gg_datatype_SearchResult_type2() : gg_datatype_SearchResult_base()
{
	rel_algebra_node temp_273 = rel_algebra::trueTable();
	temp_273 = rel_algebra::complement(temp_273);
	local_isSat = temp_273;
}

void gg_datatype_SearchResult_type3::output_answer(ostream &os) const
{
	os << "";
}

string gg_datatype_SearchResult_type3::toString() const
{
	string result = "";
	result += "UNSAT";
	return result;
}

gg_datatype_SearchResult_type3::gg_datatype_SearchResult_type3() : gg_datatype_SearchResult_base()
{
	rel_algebra_node temp_286 = rel_algebra::trueTable();
	temp_286 = rel_algebra::complement(temp_286);
	local_isSat = temp_286;
}

void gg_datatype_Argument_type1::output_name(ostream &os) const
{
	os << subtree_argId;
}

string gg_datatype_Argument_type1::toString() const
{
	string result = "";
	result += subtree_argId.toString();
	result += ".";
	return result;
}

gg_datatype_Argument_type1::gg_datatype_Argument_type1(compact_string const &argId) : gg_datatype_Argument_base(), subtree_argId(argId)
{
}

void gg_datatype_Argument_type2::output_name(ostream &os) const
{
	int64_t temp_318 = subtree_argNo;
	os << temp_318;
}

string gg_datatype_Argument_type2::toString() const
{
	string result = "";
	result += to_string(subtree_argNo);
	result += ".";
	return result;
}

gg_datatype_Argument_type2::gg_datatype_Argument_type2(int64_t const &argNo) : gg_datatype_Argument_base(), subtree_argNo(argNo)
{
}


