/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*-  */
/*
 * global-stack.h
 * Copyright (C) 2016 Shahab <shahab@tasharrofi.net>
 *
 * grounder-generator is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * grounder-generator is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _GLOBAL_STACK_H_
#define _GLOBAL_STACK_H_

#include <stack>

using namespace std;

template <typename T>
class GlobalStack
{
	private:
		static stack<T> data;
	public:
		inline static bool isEmpty() { return (data.size() == 0); }
		inline static size_t size() { return data.size(); }
		inline static T top() { return data.top(); }

		inline static T pop() { T result = data.top(); data.pop(); return result; }
		inline static void push(const T &element) { data.push(element); }
};

template <typename T>
stack<T> GlobalStack<T>::data;

#endif // _GLOBAL_STACK_H_

