/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*-  */
/*
 * compact-string.h
 * Copyright (C) 2016 Shahab <shahab@tasharrofi.net>
 *
 * grounder-generator is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * grounder-generator is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _COMPACT_STRING_H_
#define _COMPACT_STRING_H_

#include <iostream>
#include <string>

#include "prefix-tree.h"

using namespace std;

typedef PrefixTree<char> PrefixTreeBasedString;

class compact_string
{
	private:
		PrefixTreeBasedString::Sequence s;
		compact_string(PrefixTreeBasedString::Sequence ptbs) : s(ptbs) { }
	public:
		inline bool isEmpty() const { return s.isEmpty(); }
		inline char getLastChar() const { return s.getLastElement(); }
		inline compact_string getHead() const { return compact_string(s.getPrefix()); }

		inline void printToStream(ostream &os) const { s.printToStream(os); }

		inline compact_string operator+=(const compact_string &t) { s += t.s; return (*this); }
		inline compact_string operator+=(const char *str)
		{
			while ((*str) != '\0')
			{
				s += (*str);
				str++;
			}

			return (*this);
		}

		inline bool operator==(const compact_string &t) const { return s == t.s; }
		inline bool operator!=(const compact_string &t) const { return s != t.s; }

		inline size_t hash_value() const { return s.getHashValue(); }

		inline string toString() const { return (isEmpty() ? "" : getHead().toString() + getLastChar()); }

		compact_string() : s() { }
		compact_string(const char *str) : s() { while ((*str) != '\0') { s += (*str); str++; } }

		inline static compact_string make_from(const char *str) { return compact_string(str); }
		inline static compact_string make_from(int64_t n) { return compact_string(std::to_string(n).c_str()); }
};

inline compact_string operator+(const compact_string &s, const compact_string &t) { compact_string result(s); result += t; return result; }
inline compact_string operator+(const compact_string &s, const char *t) { compact_string result(s); result += t; return result; }
inline ostream &operator<<(ostream &os, const compact_string s) { s.printToStream(os); return os; }

struct compact_string_hash
{
	inline size_t operator()(const compact_string &cs) const { return cs.hash_value(); }
};

#endif // _COMPACT_STRING_H_

