#!/bin/bash

function solve_task_under_semantics
{
	(echo $inp_fileformat ; cat $inp_filename ; echo "$task $argname" ; echo $semantics) | $basedir/grounder | $basedir/sat-to-sat -n=$modelcount -sts-input=1 -print-method=1 -no-early-prop -verb=0
}

if [ "$#" = "0" ]
then
	echo "gg-sts 0.1"
	echo "Shahab Tasharrofi <shahab.tasharrofi@aalto.fi>"
	echo "Tomi Janhunen <tomi.janhunen@aalto.fi>"
	exit 0
fi

argname=""
while [ "$1" != "" ]; do
	case $1 in
		"--formats")
			echo "[tgf,apx]"
			exit 0
			;;
		"--problems")
			echo "[DC-CO,DS-CO,SE-CO,EE-CO,DC-PR,DS-PR,SE-PR,EE-PR,DC-ST,DS-ST,SE-ST,EE-ST,DC-SST,DS-SST,SE-SST,EE-SST,DC-STG,DS-STG,SE-STG,EE-STG,DC-GR,SE-GR,DC-ID,SE-ID,D3]"
			exit 0
			;;
		"-p")
			shift
			d3track=0
			modelcount=1
			if [[ "$1" == "DC-"* ]] ; then
				task="brave"
			elif [[ "$1" == "DS-"* ]] ; then
				task="skeptical"
			elif [[ "$1" == "SE-"* ]] ; then
				task="search"
			elif [[ "$1" == "EE-"* ]] ; then
				task="search"
				modelcount=0
			else
				d3track=1
			fi
				if [[ "$1" == *"-CO" ]] ; then
				semantics="complete"
			elif [[ "$1" == *"-PR" ]] ; then
				semantics="preferred"
			elif [[ "$1" == *"-ST" ]] ; then
				semantics="stable"
			elif [[ "$1" == *"-SST" ]] ; then
				semantics="semistable"
			elif [[ "$1" == *"-STG" ]] ; then
				semantics="stage"
			elif [[ "$1" == *"-GR" ]] ; then
				semantics="grounded"
			elif [[ "$1" == *"-ID" ]] ; then
				semantics="ideal"
			else
				d3track=1
			fi
			;;
		"-f")
			shift
			inp_filename=$1
			;;
		"-fo")
			shift
			inp_fileformat=$1
			;;
		"-a")
			shift
			argname=$1
			;;
	esac
	shift
done

basedir=$(dirname $0)

if [[ $d3track == 0 ]] ; then
	outputtask=$task
	if [[ $modelcount == 0 ]] ; then
		if [[ $task == "search" ]] ; then
			outputtask="enumerate"
		fi
	fi
	(echo "$outputtask" ; solve_task_under_semantics) | $basedir/formatter
else
	(
		echo "triathlon"

		task="search"
		argname=""

		modelcount=1
		semantics="grounded"
		solve_task_under_semantics

		echo "#"

		modelcount=0
		semantics="stable"
		solve_task_under_semantics

		echo "#"

		modelcount=0
		semantics="preferred"
		solve_task_under_semantics
	) | $basedir/formatter
fi

