#!/bin/bash

# This script transforms trees in the newick format
# to be used with the projection encoding

for f in $*
do
  g=${f%%.tree}
  if test -f $g.tree
  then
    echo "Creating projection in $g.lp."
    echo -n "superproj(" > $g.lp
    cat $f \
    | tr "ABCDEFGHIJKLMNOPQRSTUVWXYZ" "abcdefghijklmnopqrstuvwxyz" \
    | sed 's/:[1-9][0-9]*\.[0-9][0-9]*//g' \
    | sed 's/(/t(/g;s/;//g' | tr -d "\n" >> $g.lp
    echo -n "," >> $g.lp
    echo -n "$g" \
    | tr "ABCDEFGHIJKLMNOPQRSTUVWXYZ" "abcdefghijklmnopqrstuvwxyz" >> $g.lp
    echo ")." >> $g.lp
  else
    echo "File $g.tree does not exist!"
  fi
done
