function sR=icassoExp(sR)
%function sR=icassoExp(sR)
%
%PURPOSE
%
%To prepare Icasso result structure for exploratory analysis, i.e.,
%to compute (dis)similarity matrix, clustering, and projection. 
%
%EXAMPLES OF BASIC USAGE
%
%First we produce an Icasso result structure...
%
%   load megdata
%   sR=icassoEst('randinit',megdata,15,'lastEig',20);
%
%The following command performs the default Icasso clustering
%procedure:
%
%   sR=icassoExp(sR);
%
%The next step would be to return results launch the visualizations
%of the results: See icassoShow, icassoViz, and icassoResult. 
%
%DETAILS
%
%sR=icassoExp(sR) is equivalent of giving commands
%
%  sR=icassoSimilarity(sR,'abscorr');   % Step 1 similarities
%  sR=icassoCluster(sR,'AL');           % Step 2 clustering and
%                                                cluster validity index
%  sR=icassoProjection(sR,'cca');       % Step 3 projection
%
%You can customize the Icasso procedure by using this script
%as a model but changing the optional input parameters. See
%icassoSimilarity, icassoCluster, and icassoProjection. 

%COPYRIGHT NOTICE
%This function is a part of Icasso software library
%Copyright (C) 2003-2005 Johan Himberg
%
%This program is free software; you can redistribute it and/or
%modify it under the terms of the GNU General Public License
%as published by the Free Software Foundation; either version 2
%of the License, or any later version.
%
%This program is distributed in the hope that it will be useful,
%but WITHOUT ANY WARRANTY; without even the implied warranty of
%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%GNU General Public License for more details.
%
%You should have received a copy of the GNU General Public License
%along with this program; if not, write to the Free Software
%Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

% ver 1.3 100105

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Step 1
%
%Compute similarities between estimates as absolute values of
%their mutual linear correlations.
%
%Details:
% 1. Compute similarities (S) between sR estimates
% 2. Store the similarity matrix S in field sR.cluster.similarity. 
% 3. Record the similarity function into sR.cluster.simfcn, in
%    this case, 'abscorr'. Other possibilities are 'power' and 'corr'

sR=icassoSimilarity(sR,'abscorr');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Step 2 
%
%Cluster the estimates
%
%Details:
% 1. Compute dissimilarities from similarities as defined in function
%    sim2dis (default is simply D=1-S, if you want something else,
%    edit the function file sim2dis.m)
% 2. Compute hierarchical clustering according to the readily computed
%    dissimilarities using average-linkage strategy. Other
%    possibilities: 'CL' (comptele link) 'SL' (single-link)
% 3. Compute P=hcluster(sR.cluster.dissimilarity,'AL');
% 4. Store the partition P into field sR.cluster.partition
% 5. Store the agglomeration strategy in sR.cluster.strategy
% 6. Compute a clustering solution validity index up to L clusters
%    where L is the smallest one of 
%    - total number of randomized estimates 
%    - ceil(3*number_of_original signals) or
%    - 100 (limit due to computational load)
%    L can also be specified explicitly 
% 7. Store the index into field sR.cluster.index.R
 
sR=icassoCluster(sR,'AL','auto');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Step 3
%
%Compute the coordinates for correlation graph using Curvilinear
%Component Analysis. Other possibilities: 'mmds' (principal
%coordinates), 'sammon' (Sammon's projection). See icassoProjection
%for details.
%
%Note that the dissimilarities are slightly differently scaled than in clustering:
%
%Details:
%1. Compute similarity-to-dissimilarity transformation that is
%   found to be good for the proximity preserving projection: 
%   D=sqrt(1-sR.cluster.similarity)
%2. compute CCA on this dissimilarity matrix.

sR=icassoProjection(sR,'cca');

%%%
