/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.event.MouseInputListener;
import javax.swing.filechooser.FileFilter;

public class GuiCircuit
extends Gui {
    private static final long serialVersionUID = 1L;
    private Integer[][] circuit;
    private JLabel[][] circuitLabels;
    private List<Image> sizedImages;
    private List<Image> sizedInputs;
    private List<Image> sizedOutputs;
    private int status;
    private String name;
    private int dim;
    private int startColumn;
    private int startLine;
    private int iRed;
    private int jRed;
    private int crtTile = 0;
    private int relativeLine;
    private int relativeColumn;
    private int[][] component;
    private boolean clickMode;
    private int startSelectX;
    private int stopSelectX;
    private int startSelectY;
    private int stopSelectY;
    private List<Rectangle> rs;
    private List<Integer> is;
    private List<Integer> js;
    private RightClickMenu rightClickMenu;
    private boolean pasteMode;
    private List<BufferedImage> inputs;
    private List<BufferedImage> outputs;
    private List<String> inputNames;
    private List<String> outputNames;
    private List<Object> changes;
    private int crtChange;
    private boolean undo;
    private boolean analyzeFileCreated;
    int simCount;
    int anlzCount;
    private MyMouseListener myMouseListener;

    public GuiCircuit(int circuitWidth, int circuitHeight) {
        this.initCircuit(circuitWidth, circuitHeight, "Untitled" + Singleton.getInstance().getNrUntitled(), 0);
        int i = 0;
        while (i < circuitHeight) {
            int j = 0;
            while (j < circuitWidth) {
                this.circuit[i][j] = -1;
                ++j;
            }
            ++i;
        }
        this.resizeImages();
    }

    public GuiCircuit(String file) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            Scanner scanner = new Scanner(in);
            int circuitHeight = scanner.nextInt();
            int circuitWidth = scanner.nextInt();
            int nrInputs = scanner.nextInt();
            int nrOutputs = scanner.nextInt();
            this.initCircuit(circuitWidth, circuitHeight, file, 2);
            int i = 0;
            while (i < circuitHeight) {
                int j = 0;
                while (j < circuitWidth) {
                    this.circuit[i][j] = scanner.nextInt();
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < nrInputs) {
                String str = scanner.next();
                this.addInput(str);
                ++i;
            }
            i = 0;
            while (i < nrOutputs) {
                String str = scanner.next();
                this.addOutput(str);
                ++i;
            }
            this.resizeImages();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void addInput(String str) {
        this.inputs.add(Singleton.getInstance().createTextImage(str));
        this.inputNames.add(str);
    }

    private void addOutput(String str) {
        this.outputs.add(Singleton.getInstance().createTextImage(str));
        this.outputNames.add(str);
    }

    private void initCircuit(int circuitWidth, int circuitHeight, String name, int status) {
        System.out.println("Initiate circuit");
        if (name != null) {
            this.myMouseListener = new MyMouseListener(this);
            this.addMouseListener(this.myMouseListener);
            this.addMouseMotionListener(this.myMouseListener);
            this.name = name;
            this.enableButtons();
            this.pasteMode = false;
            this.inputs = new ArrayList<BufferedImage>();
            this.inputNames = new ArrayList<String>();
            this.outputs = new ArrayList<BufferedImage>();
            this.outputNames = new ArrayList<String>();
            this.undo = false;
            this.analyzeFileCreated = false;
            this.changes = new ArrayList<Object>();
            this.crtChange = -1;
            this.anlzCount = 0;
            this.simCount = 0;
        }
        this.dim = (Main.width - 250) / circuitWidth;
        if (this.dim > (Main.height - 260) / circuitHeight) {
            this.dim = (Main.height - 260) / circuitHeight;
        }
        if (this.dim < 10) {
            this.dim = 10;
        }
        if (this.dim > 200) {
            this.dim = 200;
        }
        this.startColumn = 0;
        this.startLine = 0;
        this.circuit = new Integer[circuitHeight][circuitWidth];
        this.paint = true;
        this.iRed = -1;
        this.jRed = -1;
        this.component = null;
        this.clickMode = false;
        this.rs = new ArrayList<Rectangle>();
        this.is = new ArrayList<Integer>();
        this.js = new ArrayList<Integer>();
        this.rightClickMenu = new RightClickMenu(this);
        this.createCircuitLabels(false);
        this.status = status;
    }

    public void changeTheme() {
        String str;
        this.inputs.clear();
        this.outputs.clear();
        int i = 0;
        while (i < this.inputNames.size()) {
            str = this.inputNames.get(i);
            this.inputs.add(Singleton.getInstance().createTextImage(str));
            ++i;
        }
        i = 0;
        while (i < this.outputNames.size()) {
            str = this.outputNames.get(i);
            this.outputs.add(Singleton.getInstance().createTextImage(str));
            ++i;
        }
        this.resizeImages();
    }

    private void enableButtons() {
        this.saveItem.setEnabled(true);
        this.saveAsItem.setEnabled(true);
        this.exportItem.setEnabled(true);
        this.zoomInItem.setEnabled(true);
        this.zoomOutItem.setEnabled(true);
        this.moveLeft.setEnabled(true);
        this.moveRight.setEnabled(true);
        this.moveUp.setEnabled(true);
        this.moveDown.setEnabled(true);
        this.undoItem.setEnabled(true);
        this.redoItem.setEnabled(true);
        this.selectModeItem.setEnabled(true);
        this.insertCompItem.setEnabled(true);
        int i = 0;
        while (i < this.methodItems.size()) {
            ((JMenuItem)this.methodItems.get(i)).setEnabled(true);
            ++i;
        }
        this.runItem.setEnabled(true);
        this.theme1.setEnabled(true);
        this.theme2.setEnabled(true);
        this.closeTaskItem.setEnabled(true);
    }

    private void createCircuitLabels(boolean resize) {
        if (this.circuitLabels != null) {
            int i = 0;
            while (i < this.circuitLabels.length) {
                int j = 0;
                while (j < this.circuitLabels[0].length) {
                    if (this.circuitLabels[i][j] != null) {
                        this.remove(this.circuitLabels[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        int printWidth = (Main.width - 250) / this.dim;
        int printHeight = (Main.height - 260) / this.dim;
        if (printWidth > this.circuit[0].length) {
            printWidth = this.circuit[0].length;
        }
        if (printHeight > this.circuit.length) {
            printHeight = this.circuit.length;
        }
        this.circuitLabels = new JLabel[printHeight][printWidth];
        int i = 0;
        while (i < printHeight) {
            int j = 0;
            while (j < printWidth) {
                int x = 150 + j * this.dim;
                int y = 130 + i * this.dim;
                this.circuitLabels[i][j] = new JLabel();
                this.circuitLabels[i][j].setBounds(x, y, this.dim, this.dim);
                this.circuitLabels[i][j].addMouseListener(this.myMouseListener);
                this.circuitLabels[i][j].addMouseMotionListener(this.myMouseListener);
                this.add(this.circuitLabels[i][j]);
                ++j;
            }
            ++i;
        }
        this.resetCircuit();
        if (resize) {
            this.resizeImages();
        }
    }

    private void resetCircuit() {
        this.iRed = -1;
        this.paint = true;
    }

    private void change() {
        System.out.println("Change action ");
        int size = this.changes.size();
        int i = this.crtChange + 1;
        while (i < size) {
            this.changes.remove(this.crtChange + 1);
            ++i;
        }
        this.changes.add(this.copyCircuit(this.circuit));
        ++this.crtChange;
        this.undo = false;
    }

    private void undo() {
        System.out.println("Undo action");
        if (!this.undo) {
            this.changes.add(this.copyCircuit(this.circuit));
            this.undo = true;
        }
        if (this.crtChange >= 0) {
            int circuitHeight = ((Integer[][])this.changes.get(this.crtChange)).length;
            int circuitWidth = ((Integer[][])this.changes.get(this.crtChange))[0].length;
            this.initCircuit(circuitWidth, circuitHeight, null, 1);
            this.circuit = this.copyCircuit((Integer[][])this.changes.get(this.crtChange));
            this.paint = true;
            --this.crtChange;
        }
    }

    private void redo() {
        System.out.println("Redo action");
        if (this.crtChange < this.changes.size() - 2) {
            int circuitHeight = ((Integer[][])this.changes.get(this.crtChange + 2)).length;
            int circuitWidth = ((Integer[][])this.changes.get(this.crtChange + 2))[0].length;
            this.initCircuit(circuitWidth, circuitHeight, null, 1);
            this.circuit = this.copyCircuit((Integer[][])this.changes.get(this.crtChange + 2));
            this.paint = true;
            ++this.crtChange;
        }
    }

    private Integer[][] copyCircuit(Integer[][] circuit) {
        Integer[][] copy = new Integer[circuit.length][circuit[0].length];
        int i = 0;
        while (i < circuit.length) {
            int j = 0;
            while (j < circuit[0].length) {
                copy[i][j] = circuit[i][j];
                ++j;
            }
            ++i;
        }
        return copy;
    }

    private void resizeImages() {
        this.sizedImages = null;
        this.sizedImages = new ArrayList<Image>();
        int i = 0;
        while (i < 21) {
            this.sizedImages.add(this.resizeImage((BufferedImage)this.tiles.get(i)));
            ++i;
        }
        this.sizedInputs = null;
        this.sizedInputs = new ArrayList<Image>();
        i = 0;
        while (i < this.inputs.size()) {
            this.sizedInputs.add(this.resizeImage(this.inputs.get(i)));
            ++i;
        }
        this.sizedOutputs = null;
        this.sizedOutputs = new ArrayList<Image>();
        i = 0;
        while (i < this.outputs.size()) {
            this.sizedOutputs.add(this.resizeImage(this.outputs.get(i)));
            ++i;
        }
    }

    private Image resizeImage(BufferedImage bi) {
        return bi.getScaledInstance(this.dim, this.dim, 1);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        JComponent source = (JComponent)e.getSource();
        if (this.tools.contains(source) || this.toolsMenuItems.contains(source)) {
            int index = this.tools.indexOf(source);
            if (index == -1) {
                index = this.toolsMenuItems.indexOf(source);
            }
            if (index != 19) {
                this.crtTile = index;
                this.clickMode = false;
                this.destroySelection();
            } else {
                this.clickMode = true;
            }
        } else if (source.equals(this.saveAsItem)) {
            System.out.println("Save As ... ");
            this.saveAs();
        } else if (source.equals(this.saveItem)) {
            System.out.println("Save" + this.status);
            if (this.status == 1) {
                this.save();
            } else if (this.status == 0) {
                this.saveAs();
            }
        } else if (source.equals(this.zoomInItem)) {
            System.out.println("Zoom in");
            if (this.dim < 200) {
                this.dim += 3;
            }
            this.createCircuitLabels(true);
        } else if (source.equals(this.zoomOutItem)) {
            System.out.println("Zoom out");
            if (this.dim > 10) {
                this.dim -= 3;
            }
            this.createCircuitLabels(true);
        } else if (source.equals(this.moveLeft)) {
            if (this.startColumn > 0) {
                --this.startColumn;
            }
            this.resetCircuit();
        } else if (source.equals(this.moveRight)) {
            if (this.startColumn < this.circuit[0].length - this.circuitLabels[0].length) {
                ++this.startColumn;
            }
            this.resetCircuit();
        } else if (source.equals(this.moveUp)) {
            if (this.startLine > 0) {
                --this.startLine;
            }
            this.resetCircuit();
        } else if (source.equals(this.moveDown)) {
            if (this.startLine < this.circuit.length - this.circuitLabels.length) {
                ++this.startLine;
            }
            this.resetCircuit();
        } else if (source.equals(this.selectModeItem)) {
            System.out.println("Switch mode to click mode");
            this.clickMode = true;
        } else if (source.equals(this.insertCompItem)) {
            System.out.println("User wants to insert a new component");
            Singleton.getInstance().insertSoundPlay();
            String file = this.openPopupWindow();
            try {
                BufferedReader in = new BufferedReader(new FileReader(file));
                if (in != null) {
                    this.change();
                    Scanner scanner = new Scanner(in.readLine());
                    int componentHeight = scanner.nextInt();
                    int componentWidth = scanner.nextInt();
                    this.component = new int[componentHeight][componentWidth];
                    int i = 0;
                    while (i < componentHeight) {
                        scanner = new Scanner(in.readLine());
                        int j = 0;
                        while (j < componentWidth) {
                            this.component[i][j] = scanner.nextInt();
                            ++j;
                        }
                        ++i;
                    }
                    in.close();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else if (source.equals(this.rightClickMenu.getCopyItem())) {
            System.out.println("Copy action");
            this.createSelectionComponent();
            this.destroySelection();
        } else if (source.equals(this.rightClickMenu.getCutItem())) {
            System.out.println("Cut action");
            this.createSelectionComponent();
            int i = 0;
            while (i < this.is.size()) {
                this.circuit[this.startLine + this.is.get((int)i).intValue()][this.startColumn + this.js.get((int)i).intValue()] = -1;
                ++i;
            }
            this.destroySelection();
        } else if (source.equals(this.rightClickMenu.getPasteItem())) {
            System.out.println("Paste action");
            this.component = null;
            this.component = Main.pasteComponent;
            if (this.component.length == 1 && this.component[0].length == 1) {
                this.circuit[this.iRed][this.jRed] = this.component[0][0];
            } else {
                this.pasteMode = true;
            }
        } else if (source.equals(this.rightClickMenu.getInsertRowsAbove())) {
            InsertDialog insertDialog = new InsertDialog();
            insertDialog.setVisible(true);
            if (insertDialog.hasData()) {
                this.insertRows(insertDialog.getData());
            }
            insertDialog = null;
        } else if (source.equals(this.rightClickMenu.getInsertRowsBelow())) {
            InsertDialog insertDialog = new InsertDialog();
            insertDialog.setVisible(true);
            if (insertDialog.hasData()) {
                ++this.relativeLine;
                this.insertRows(insertDialog.getData());
            }
            insertDialog = null;
        } else if (source.equals(this.rightClickMenu.getRemoveRowItem())) {
            Singleton.getInstance().deleteSoundPlay();
            this.change();
            this.insertRows(-1);
        } else if (source.equals(this.rightClickMenu.getDeleteRowItem())) {
            Singleton.getInstance().deleteSoundPlay();
            this.change();
            int j = 0;
            while (j < this.circuit[0].length) {
                this.circuit[this.relativeLine][j] = -1;
                ++j;
            }
        } else if (source.equals(this.rightClickMenu.getInsertColumnsLeft())) {
            InsertDialog insertDialog = new InsertDialog();
            insertDialog.setVisible(true);
            if (insertDialog.hasData()) {
                this.insertColumns(insertDialog.getData());
            }
            insertDialog = null;
        } else if (source.equals(this.rightClickMenu.getInsertColumnsRight())) {
            InsertDialog insertDialog = new InsertDialog();
            insertDialog.setVisible(true);
            if (insertDialog.hasData()) {
                ++this.relativeColumn;
                this.insertColumns(insertDialog.getData());
            }
            insertDialog = null;
        } else if (source.equals(this.rightClickMenu.getRemoveColumnItem())) {
            Singleton.getInstance().deleteSoundPlay();
            this.change();
            this.insertColumns(-1);
        } else if (source.equals(this.rightClickMenu.getDeleteColumnItem())) {
            Singleton.getInstance().deleteSoundPlay();
            this.change();
            int i = 0;
            while (i < this.circuit.length) {
                this.circuit[i][this.relativeColumn] = -1;
                ++i;
            }
        } else if (source.equals(this.rightClickMenu.getDeleteItem())) {
            Singleton.getInstance().deleteSoundPlay();
            this.change();
            if (this.rs.size() > 0) {
                this.deleteSelectionComponent();
                this.destroySelection();
            } else {
                this.circuit[this.iRed][this.jRed] = -1;
            }
        } else if (this.methodItems.contains(source)) {
            int index = this.methodItems.indexOf(source);
            System.out.println(String.valueOf((String)this.execNamePerMethod.get(index)) + " action ");
            if (!this.analyzeFileCreated || this.status != 2) {
                this.createAnalyzeFile();
            }
            AnalyzeDialog analyzeDialog = new AnalyzeDialog((Integer)this.nrParamPerMethod.get(index));
            analyzeDialog.setVisible(true);
            if (analyzeDialog.hasData()) {
                String parameters = analyzeDialog.getData();
                this.createAnalyze(this.name, (String)this.execNamePerMethod.get(index), parameters);
            }
        } else if (source.equals(this.undoItem)) {
            System.out.println("Undo action");
            this.undo();
        } else if (source.equals(this.redoItem)) {
            System.out.println("Redo action");
            this.redo();
        } else if (source.equals(this.exportItem)) {
            String file = null;
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".pdf") || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "TNN Files";
                }
            });
            int r = chooser.showSaveDialog(this);
            if (r == 0 && !(file = chooser.getSelectedFile().getPath()).substring(file.length() - 4, file.length()).equals(".pdf")) {
                file = String.valueOf(file) + ".pdf";
            }
            int height = this.circuitLabels.length * this.dim;
            int width = this.circuitLabels[0].length * this.dim;
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics g = ((Image)image).getGraphics();
            int i = this.startLine;
            while (i < this.startLine + this.circuitLabels.length) {
                int j = this.startColumn;
                while (j < this.startColumn + this.circuit[0].length) {
                    int x = (j - this.startColumn) * this.dim;
                    int y = (i - this.startLine) * this.dim;
                    if (this.circuit[i][j] < 0) {
                        g.drawImage(this.sizedImages.get(20), x, y, null);
                    } else {
                        int index;
                        int c = this.circuit[i][j];
                        if (c < 17) {
                            g.drawImage(this.sizedImages.get(c), x, y, null);
                        } else if (c % 2 == 1) {
                            index = (c - 17) / 2;
                            g.drawImage(this.sizedInputs.get(index), x, y, null);
                        } else {
                            index = (c - 18) / 2;
                            g.drawImage(this.sizedOutputs.get(index), x, y, null);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (file != null) {
                Singleton.getInstance().export(file, image, height, width);
            }
        } else if (source.equals(this.runItem)) {
            System.out.println("runTime");
            if (!this.analyzeFileCreated || this.status != 2) {
                this.createAnalyzeFile();
            }
            this.createSimulation(this.name);
        } else if (source.equals(this.theme1)) {
            if (Singleton.getInstance().getCrtThemeIndex() != 0) {
                Singleton.getInstance().setCrtThemeIndex(0);
                Singleton.getInstance().changeTheme();
            }
        } else if (source.equals(this.theme2) && Singleton.getInstance().getCrtThemeIndex() != 1) {
            Singleton.getInstance().setCrtThemeIndex(1);
            Singleton.getInstance().changeTheme();
        }
        if (this.status == 2) {
            this.status = 1;
        }
        this.paint = true;
    }

    private void createAnalyzeFile() {
        String file = Singleton.getInstance().tranformName(this.name);
        file = file.substring(0, file.length() - 3);
        file = String.valueOf(file) + "anlz";
        try {
            int j;
            int size;
            PrintWriter out = new PrintWriter(file);
            out.print(String.valueOf(this.circuit.length) + " ");
            out.print(String.valueOf(this.circuit[0].length) + " ");
            int nrOutputs = 0;
            int nrInputs = 0;
            int i = 0;
            while (i < this.circuit.length) {
                int j2 = 0;
                while (j2 < this.circuit[0].length) {
                    if (this.circuit[i][j2] >= 17) {
                        if (this.circuit[i][j2] % 2 == 0) {
                            ++nrOutputs;
                        } else {
                            ++nrInputs;
                        }
                    }
                    ++j2;
                }
                ++i;
            }
            ArrayList<Integer> OutputGroups = new ArrayList<Integer>();
            ArrayList<Integer> InputGroups = new ArrayList<Integer>();
            ArrayList<Integer> inputs = new ArrayList<Integer>();
            ArrayList<Integer> outputs = new ArrayList<Integer>();
            List<Integer> crtOutput = this.getCrtIO(18, OutputGroups, outputs, 15);
            List<Integer> crtInput = this.getCrtIO(17, InputGroups, inputs, 15 + nrOutputs);
            int nrVdd = this.countTiles(16);
            int nrVcc = this.countTiles(15);
            int nrP = this.countTiles(1);
            int nrN = this.countTiles(2);
            out.print(String.valueOf(nrOutputs) + " ");
            out.print(String.valueOf(nrInputs) + " ");
            out.print(String.valueOf(nrVdd) + " ");
            out.print(String.valueOf(nrVcc) + " ");
            out.print(String.valueOf(nrP) + " ");
            out.println(nrN);
            int crtVdd = 15 + nrOutputs + nrInputs;
            int crtVcc = crtVdd + nrVdd;
            int crtP = crtVcc + nrVcc;
            int crtN = crtP + nrP;
            int i2 = 0;
            while (i2 < this.circuit.length) {
                int j3 = 0;
                while (j3 < this.circuit[0].length) {
                    int crt;
                    int index;
                    int c = this.circuit[i2][j3];
                    if (c == 1) {
                        out.print(String.valueOf(crtP) + " ");
                        ++crtP;
                    } else if (c == 2) {
                        out.print(String.valueOf(crtN) + " ");
                        ++crtN;
                    } else if (c == 16) {
                        out.print(String.valueOf(crtVdd) + " ");
                        ++crtVdd;
                    } else if (c == 15) {
                        out.print(String.valueOf(crtVcc) + " ");
                        ++crtVcc;
                    } else if (c >= 18 && c % 2 == 0) {
                        index = OutputGroups.indexOf(c);
                        crt = crtOutput.get(index);
                        out.print(String.valueOf(crt) + " ");
                        crtOutput.set(index, ++crt);
                    } else if (c >= 17 && c % 2 == 1) {
                        index = InputGroups.indexOf(c);
                        crt = crtInput.get(index);
                        out.print(String.valueOf(crt) + " ");
                        crtInput.set(index, ++crt);
                    } else {
                        if (c < 0) {
                            c = 0;
                        }
                        out.print(String.valueOf(c) + " ");
                    }
                    ++j3;
                }
                out.println();
                ++i2;
            }
            out.println(String.valueOf(crtOutput.size()) + " ");
            i2 = 0;
            while (i2 < OutputGroups.size()) {
                size = (Integer)outputs.get(i2);
                out.print(String.valueOf(size) + " ");
                j = 0;
                while (j < size) {
                    out.print(String.valueOf(crtOutput.get(i2) - size + j) + " ");
                    ++j;
                }
                out.println();
                ++i2;
            }
            out.println(String.valueOf(crtInput.size()) + " ");
            i2 = 0;
            while (i2 < InputGroups.size()) {
                size = (Integer)inputs.get(i2);
                out.print(String.valueOf(size) + " ");
                j = 0;
                while (j < size) {
                    out.print(String.valueOf(crtInput.get(i2) - size + j) + " ");
                    ++j;
                }
                out.println();
                ++i2;
            }
            out.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        this.analyzeFileCreated = true;
    }

    private void createAnalyze(String file, String exec, String parameters) {
        System.out.println("Create analyze file");
        Main.guiList.add(new GuiAnalyze(file, this.anlzCount, exec, parameters));
        ++this.anlzCount;
        file = file.substring(0, file.length() - 3);
        file = String.valueOf(file) + "anlz" + " - " + (this.anlzCount - 1);
        this.updateMain(Singleton.getInstance().tranformName(file));
    }

    private void createSimulation(String file) {
        System.out.println("Create simulation action");
        int nrOutputs = 0;
        int i = 0;
        while (i < this.circuit.length) {
            int j = 0;
            while (j < this.circuit[0].length) {
                if (this.circuit[i][j] >= 17 && this.circuit[i][j] % 2 == 0) {
                    ++nrOutputs;
                }
                ++j;
            }
            ++i;
        }
        ArrayList<Integer> OutputGroups = new ArrayList<Integer>();
        ArrayList<Integer> InputGroups = new ArrayList<Integer>();
        ArrayList<Integer> inputs = new ArrayList<Integer>();
        ArrayList<Integer> outputs = new ArrayList<Integer>();
        this.getCrtIO(18, OutputGroups, outputs, 15);
        this.getCrtIO(17, InputGroups, inputs, 15 + nrOutputs);
        ArrayList<String> out = new ArrayList<String>();
        ArrayList<String> in = new ArrayList<String>();
        int i2 = 0;
        while (i2 < OutputGroups.size()) {
            int j = 0;
            while (j < (Integer)outputs.get(i2)) {
                out.add(this.outputNames.get(((Integer)OutputGroups.get(i2) - 18) / 2));
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < InputGroups.size()) {
            in.add(this.inputNames.get(((Integer)InputGroups.get(i2) - 17) / 2));
            ++i2;
        }
        Main.guiList.add(new GuiSimulation(file, this.simCount, out, in));
        ++this.simCount;
        file = file.substring(0, file.length() - 3);
        file = String.valueOf(file) + "sim" + " - " + (this.simCount - 1);
        this.updateMain(Singleton.getInstance().tranformName(file));
    }

    private void updateMain(String taskName) {
        Main.crt = Main.guiList.size() - 1;
        Main.x = true;
        taskComboBox.addItem(taskName);
        taskComboBox.setSelectedIndex(taskComboBox.getItemCount() - 1);
        System.out.println("Main updated");
    }

    private List<Integer> getCrtIO(int tileId, List<Integer> IOGroups, List<Integer> IOs, int startPosition) {
        int i = 0;
        while (i < this.circuit.length) {
            int j = 0;
            while (j < this.circuit[0].length) {
                int c = this.circuit[i][j];
                if (c >= tileId && c % 2 == tileId % 2) {
                    int index = IOGroups.indexOf(c);
                    if (index == -1) {
                        IOGroups.add(c);
                        IOs.add(1);
                    } else {
                        int nr = IOs.get(index);
                        IOs.set(index, ++nr);
                    }
                }
                ++j;
            }
            ++i;
        }
        ArrayList<Integer> crtIO = new ArrayList<Integer>();
        crtIO.add(startPosition);
        int start = startPosition;
        int i2 = 0;
        while (i2 < IOs.size() - 1) {
            crtIO.add(start += IOs.get(i2).intValue());
            ++i2;
        }
        return crtIO;
    }

    private int countTiles(int tileId) {
        int nr = 0;
        int i = 0;
        while (i < this.circuit.length) {
            int j = 0;
            while (j < this.circuit[0].length) {
                if (this.circuit[i][j] == tileId) {
                    ++nr;
                }
                ++j;
            }
            ++i;
        }
        return nr;
    }

    private void insertRows(int nr) {
        int j;
        int newHeight = this.circuit.length + nr;
        int newWidth = this.circuit[0].length;
        Singleton.getInstance().insertSoundPlay();
        this.change();
        int[][] newCircuit = new int[newHeight][newWidth];
        int i = 0;
        while (i < newHeight) {
            j = 0;
            while (j < newWidth) {
                newCircuit[i][j] = i < this.relativeLine ? this.circuit[i][j] : (i < this.relativeLine + nr ? -1 : this.circuit[i - nr][j]);
                ++j;
            }
            ++i;
        }
        this.initCircuit(newWidth, newHeight, null, 1);
        i = 0;
        while (i < newHeight) {
            j = 0;
            while (j < newWidth) {
                this.circuit[i][j] = newCircuit[i][j];
                ++j;
            }
            ++i;
        }
        this.resizeImages();
    }

    private void insertColumns(int nr) {
        int j;
        int newHeight = this.circuit.length;
        int newWidth = this.circuit[0].length + nr;
        Singleton.getInstance().insertSoundPlay();
        this.change();
        int[][] newCircuit = new int[newHeight][newWidth];
        int i = 0;
        while (i < newHeight) {
            j = 0;
            while (j < newWidth) {
                newCircuit[i][j] = j < this.relativeColumn ? this.circuit[i][j] : (j < this.relativeColumn + nr ? -1 : this.circuit[i][j - nr]);
                ++j;
            }
            ++i;
        }
        this.initCircuit(newWidth, newHeight, null, 1);
        i = 0;
        while (i < newHeight) {
            j = 0;
            while (j < newWidth) {
                this.circuit[i][j] = newCircuit[i][j];
                ++j;
            }
            ++i;
        }
        this.resizeImages();
    }

    private void createSelectionComponent() {
        if (this.is.size() > 0) {
            int jmin;
            int imin;
            int imax = imin = this.is.get(0).intValue();
            int jmax = jmin = this.js.get(0).intValue();
            int i = 1;
            while (i < this.is.size()) {
                int x = this.is.get(i);
                if (x < imin) {
                    imin = x;
                } else if (x > imax) {
                    imax = x;
                }
                x = this.js.get(i);
                if (x < jmin) {
                    jmin = x;
                } else if (x > jmax) {
                    jmax = x;
                }
                ++i;
            }
            Main.pasteComponent = new int[imax - imin + 1][jmax - jmin + 1];
            Main.pasteInputs.clear();
            Main.pasteOutputs.clear();
            i = 0;
            while (i < this.is.size()) {
                int c;
                Main.pasteComponent[this.is.get((int)i).intValue() - imin][this.js.get((int)i).intValue() - jmin] = c = this.circuit[this.startLine + this.is.get(i)][this.startColumn + this.js.get(i)].intValue();
                if (c >= 17) {
                    if (c % 2 == 1) {
                        if (!Main.pasteInputs.contains(c)) {
                            Main.pasteInputs.add(this.inputNames.get((c - 17) / 2));
                            Main.pasteInputs.add(c);
                        }
                    } else if (!Main.pasteOutputs.contains(c)) {
                        Main.pasteOutputs.add(this.outputNames.get((c - 18) / 2));
                        Main.pasteOutputs.add(c);
                    }
                }
                ++i;
            }
        } else {
            int c;
            Main.pasteComponent = new int[1][1];
            Main.pasteInputs.clear();
            Main.pasteOutputs.clear();
            Main.pasteComponent[0][0] = c = this.circuit[this.iRed][this.jRed].intValue();
            if (c > 17) {
                if (c % 2 == 1) {
                    Main.pasteInputs.add(this.inputNames.get((c - 17) / 2));
                    Main.pasteInputs.add(c);
                } else {
                    Main.pasteOutputs.add(this.outputNames.get((c - 18) / 2));
                    Main.pasteOutputs.add(c);
                }
            }
        }
    }

    private void deleteSelectionComponent() {
        int jmin;
        int imin;
        int imax = imin = this.is.get(0).intValue();
        int jmax = jmin = this.js.get(0).intValue();
        int i = 1;
        while (i < this.is.size()) {
            int x = this.is.get(i);
            if (x < imin) {
                imin = x;
            } else if (x > imax) {
                imax = x;
            }
            x = this.js.get(i);
            if (x < jmin) {
                jmin = x;
            } else if (x > jmax) {
                jmax = x;
            }
            ++i;
        }
        i = 0;
        while (i < this.is.size()) {
            this.circuit[this.startLine + this.is.get((int)i).intValue()][this.startColumn + this.js.get((int)i).intValue()] = -1;
            ++i;
        }
    }

    private void destroySelection() {
        this.rs.clear();
        this.is.clear();
        this.js.clear();
    }

    private AlphaComposite makeComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    @Override
    public void paint(Graphics g) {
        int y;
        int x;
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        int i = this.startLine;
        while (i < this.startLine + this.circuitLabels.length) {
            int j = this.startColumn;
            while (j < this.startColumn + this.circuitLabels[0].length) {
                x = 150 + (j - this.startColumn) * this.dim;
                y = 130 + (i - this.startLine) * this.dim;
                if (this.circuit[i][j] < 0) {
                    g.drawImage(this.sizedImages.get(20), x, y, null);
                } else {
                    int index;
                    int c = this.circuit[i][j];
                    if (c < 17) {
                        g.drawImage(this.sizedImages.get(c), x, y, null);
                    } else if (c % 2 == 1) {
                        index = (c - 17) / 2;
                        g.drawImage(this.sizedInputs.get(index), x, y, null);
                    } else {
                        index = (c - 18) / 2;
                        g.drawImage(this.sizedOutputs.get(index), x, y, null);
                    }
                }
                ++j;
            }
            ++i;
        }
        if (this.iRed >= 0 && (!this.clickMode || this.pasteMode)) {
            g2d.setComposite(this.makeComposite(0.5f));
            if (this.component == null) {
                x = 150 + (this.jRed - this.startColumn) * this.dim;
                y = 130 + (this.iRed - this.startLine) * this.dim;
                g2d.setColor(OVER_TILE_COLOR);
                g2d.fillRect(x, y, this.dim, this.dim);
            } else if (this.iRed + this.component.length <= this.circuit.length && this.jRed + this.component[0].length <= this.circuit[0].length) {
                int k = 0;
                while (k < this.component.length) {
                    int m = 0;
                    while (m < this.component[0].length) {
                        x = 150 + (this.jRed + m - this.startColumn) * this.dim;
                        y = 130 + (this.iRed + k - this.startLine) * this.dim;
                        g2d.setColor(OVER_TILE_COLOR);
                        g2d.fillRect(x, y, this.dim, this.dim);
                        ++m;
                    }
                    ++k;
                }
            }
            g2d.setComposite(this.makeComposite(1.0f));
        }
        Image im = ((BufferedImage)this.tiles.get(this.crtTile)).getScaledInstance(30, 30, 1);
        g.drawImage(im, (Main.width - 50) / 2 - this.dim / 2, 30, null);
        g.setColor(ARROW_COLOR);
        if (this.startColumn > 0) {
            g.fillOval(70, Main.fullSizeHeight / 2, 20, 20);
        }
        if (this.startLine > 0) {
            g.fillOval(Main.fullSizeWidth / 2, 80, 20, 20);
        }
        if (this.circuitLabels.length < this.circuit.length) {
            g.fillOval(Main.fullSizeWidth / 2, Main.fullSizeHeight - 80, 20, 20);
        }
        if (this.circuitLabels[0].length < this.circuit[0].length) {
            g.fillOval(Main.fullSizeWidth - 70, Main.fullSizeHeight / 2, 20, 20);
        }
        if (this.clickMode && this.startSelectX != -1) {
            boolean xInterchanged = false;
            boolean yInterchanged = false;
            if (this.startSelectX > this.stopSelectX) {
                this.interchange('\u0000');
                xInterchanged = true;
            }
            if (this.startSelectY > this.stopSelectY) {
                this.interchange('\u0001');
                yInterchanged = true;
            }
            g2d.setComposite(this.makeComposite(0.5f));
            g2d.setColor(SELECT_COLOR);
            g2d.fillRect(this.startSelectX, this.startSelectY, this.stopSelectX - this.startSelectX, this.stopSelectY - this.startSelectY);
            if (xInterchanged) {
                this.interchange('\u0000');
            }
            if (yInterchanged) {
                this.interchange('\u0001');
            }
        }
        int i2 = 0;
        while (i2 < this.rs.size()) {
            Rectangle r = this.rs.get(i2);
            g2d.setComposite(this.makeComposite(0.5f));
            g2d.setColor(SELECT_COLOR);
            g2d.fillRect(r.x, r.y, r.width, r.height);
            ++i2;
        }
    }

    protected void save() {
        this.writeToFile(this.name);
    }

    protected void saveAs() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".tnn") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "TNN Files";
            }
        });
        int r = chooser.showSaveDialog(this);
        if (r == 0) {
            String file = chooser.getSelectedFile().getPath();
            if (!file.substring(file.length() - 4, file.length()).equals(".tnn")) {
                file = String.valueOf(file) + ".tnn";
            }
            this.writeToFile(file);
            String string = Singleton.getInstance().tranformName(this.name);
            int index = 0;
            while (index < taskComboBox.getItemCount()) {
                if (taskComboBox.getItemAt(index).equals(string)) break;
                ++index;
            }
            this.name = file;
            string = Singleton.getInstance().tranformName(this.name);
            taskComboBox.insertItemAt(string, index);
            taskComboBox.removeItemAt(index + 1);
        }
    }

    private void writeToFile(String file) {
        try {
            PrintWriter out = new PrintWriter(file);
            out.println(String.valueOf(this.circuit.length) + " " + this.circuit[0].length + " " + this.inputs.size() + " " + this.outputs.size());
            int i = 0;
            while (i < this.circuit.length) {
                int j = 0;
                while (j < this.circuit[0].length) {
                    out.print(this.circuit[i][j] + " ");
                    ++j;
                }
                out.println();
                ++i;
            }
            i = 0;
            while (i < this.inputNames.size()) {
                out.println(this.inputNames.get(i));
                ++i;
            }
            i = 0;
            while (i < this.outputNames.size()) {
                out.println(this.outputNames.get(i));
                ++i;
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.status = 2;
        this.analyzeFileCreated = false;
    }

    private void interchange(char XorY) {
        if (XorY == '\u0000') {
            int aux = this.startSelectX;
            this.startSelectX = this.stopSelectX;
            this.stopSelectX = aux;
        } else {
            int aux = this.startSelectY;
            this.startSelectY = this.stopSelectY;
            this.stopSelectY = aux;
        }
    }

    class MyMouseListener
    implements MouseListener,
    MouseInputListener {
        private GuiCircuit parent;

        public MyMouseListener(GuiCircuit parent) {
            this.parent = parent;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            Object src = arg0.getSource();
            if (arg0.getButton() == 1) {
                if (src instanceof JLabel) {
                    JLabel source = (JLabel)arg0.getSource();
                    if (!GuiCircuit.this.clickMode || GuiCircuit.this.pasteMode) {
                        int i = GuiCircuit.this.startLine;
                        while (i < GuiCircuit.this.startLine + GuiCircuit.this.circuitLabels.length) {
                            int j = GuiCircuit.this.startColumn;
                            while (j < GuiCircuit.this.startColumn + GuiCircuit.this.circuitLabels[0].length) {
                                if (source.equals(GuiCircuit.this.circuitLabels[i - GuiCircuit.this.startLine][j - GuiCircuit.this.startColumn])) {
                                    int k;
                                    Singleton.getInstance().insertSoundPlay();
                                    GuiCircuit.this.change();
                                    if (GuiCircuit.this.pasteMode) {
                                        k = 0;
                                        while (k < Main.pasteInputs.size()) {
                                            String inputName = (String)Main.pasteInputs.get(k);
                                            if (!GuiCircuit.this.inputNames.contains(inputName)) {
                                                GuiCircuit.this.addInput(inputName);
                                            }
                                            k += 2;
                                        }
                                        k = 0;
                                        while (k < Main.pasteOutputs.size()) {
                                            String outputName = (String)Main.pasteOutputs.get(k);
                                            if (!GuiCircuit.this.outputNames.contains(outputName)) {
                                                GuiCircuit.this.addOutput(outputName);
                                            }
                                            k += 2;
                                        }
                                        GuiCircuit.this.resizeImages();
                                        k = 0;
                                        while (k < GuiCircuit.this.component.length) {
                                            int m = 0;
                                            while (m < GuiCircuit.this.component[0].length) {
                                                int c = GuiCircuit.this.component[k][m];
                                                if (c >= 17) {
                                                    String name;
                                                    int q;
                                                    if (c % 2 == 1) {
                                                        q = Main.pasteInputs.indexOf(c);
                                                        name = (String)Main.pasteInputs.get(q - 1);
                                                        ((GuiCircuit)GuiCircuit.this).component[k][m] = 17 + 2 * GuiCircuit.this.inputNames.indexOf(name);
                                                    } else {
                                                        q = Main.pasteOutputs.indexOf(c);
                                                        name = (String)Main.pasteOutputs.get(q - 1);
                                                        ((GuiCircuit)GuiCircuit.this).component[k][m] = 18 + 2 * GuiCircuit.this.outputNames.indexOf(name);
                                                    }
                                                }
                                                ++m;
                                            }
                                            ++k;
                                        }
                                        GuiCircuit.this.pasteMode = false;
                                        GuiCircuit.this.iRed = -1;
                                    }
                                    if (GuiCircuit.this.component == null) {
                                        GuiCircuit.this.iRed = i;
                                        GuiCircuit.this.jRed = j;
                                        if (GuiCircuit.this.crtTile == 17 || GuiCircuit.this.crtTile == 18) {
                                            this.insertIOTile();
                                        } else {
                                            ((GuiCircuit)GuiCircuit.this).circuit[i][j] = GuiCircuit.this.crtTile;
                                        }
                                    } else if (i + GuiCircuit.this.component.length <= GuiCircuit.this.circuit.length && j + GuiCircuit.this.component[0].length <= GuiCircuit.this.circuit[0].length) {
                                        k = 0;
                                        while (k < GuiCircuit.this.component.length) {
                                            int m = 0;
                                            while (m < GuiCircuit.this.component[0].length) {
                                                ((GuiCircuit)GuiCircuit.this).circuit[i + k][j + m] = GuiCircuit.this.component[k][m];
                                                ++m;
                                            }
                                            ++k;
                                        }
                                        GuiCircuit.this.component = null;
                                    }
                                }
                                ++j;
                            }
                            ++i;
                        }
                        if (GuiCircuit.this.status == 2) {
                            GuiCircuit.this.status = 1;
                        }
                        GuiCircuit.this.paint = true;
                    }
                }
            } else if (src instanceof JLabel) {
                this.setCurrentTile(src);
                Rectangle r = ((JLabel)src).getBounds();
                GuiCircuit.this.rightClickMenu.show(this.parent, r.x + arg0.getX(), r.y + arg0.getY());
                GuiCircuit.this.relativeLine = GuiCircuit.this.iRed;
                GuiCircuit.this.relativeColumn = GuiCircuit.this.jRed;
            }
        }

        private void insertIOTile() {
            GuiCircuit.this.relativeLine = GuiCircuit.this.iRed;
            GuiCircuit.this.relativeColumn = GuiCircuit.this.jRed;
            IODialog ioDialog = GuiCircuit.this.crtTile == 17 ? new IODialog("input", GuiCircuit.this.inputNames) : new IODialog("output", GuiCircuit.this.outputNames);
            ioDialog.setVisible(true);
            if (ioDialog.hasData()) {
                List<Object> list = ioDialog.getData();
                int type = (Integer)list.get(0);
                if (type == 0) {
                    int k = (Integer)list.get(1);
                    ((GuiCircuit)GuiCircuit.this).circuit[((GuiCircuit)GuiCircuit.this).relativeLine][((GuiCircuit)GuiCircuit.this).relativeColumn] = GuiCircuit.this.crtTile + k * 2;
                } else {
                    String str = (String)list.get(1);
                    int k = GuiCircuit.this.crtTile == 17 ? GuiCircuit.this.inputNames.indexOf(str) : GuiCircuit.this.outputNames.indexOf(str);
                    if (k == -1) {
                        k = GuiCircuit.this.crtTile == 17 ? GuiCircuit.this.inputNames.size() : GuiCircuit.this.outputNames.size();
                        BufferedImage bi = Singleton.getInstance().createTextImage(str);
                        if (GuiCircuit.this.crtTile == 17) {
                            GuiCircuit.this.inputs.add(bi);
                            GuiCircuit.this.inputNames.add(str);
                            GuiCircuit.this.sizedInputs.add(GuiCircuit.this.resizeImage(bi));
                        } else {
                            GuiCircuit.this.outputs.add(bi);
                            GuiCircuit.this.outputNames.add(str);
                            GuiCircuit.this.sizedOutputs.add(GuiCircuit.this.resizeImage(bi));
                        }
                    }
                    ((GuiCircuit)GuiCircuit.this).circuit[((GuiCircuit)GuiCircuit.this).relativeLine][((GuiCircuit)GuiCircuit.this).relativeColumn] = GuiCircuit.this.crtTile + k * 2;
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            Object src = arg0.getSource();
            if (src instanceof JLabel && !GuiCircuit.this.rightClickMenu.isVisible()) {
                this.setCurrentTile(src);
            }
        }

        private void setCurrentTile(Object source) {
            int i = GuiCircuit.this.startLine;
            while (i < GuiCircuit.this.startLine + GuiCircuit.this.circuitLabels.length) {
                int j = GuiCircuit.this.startColumn;
                while (j < GuiCircuit.this.startColumn + GuiCircuit.this.circuitLabels[0].length) {
                    if (source.equals(GuiCircuit.this.circuitLabels[i - GuiCircuit.this.startLine][j - GuiCircuit.this.startColumn])) {
                        GuiCircuit.this.iRed = i;
                        GuiCircuit.this.jRed = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            GuiCircuit.this.paint = true;
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            if (!GuiCircuit.this.clickMode && !GuiCircuit.this.rightClickMenu.isVisible()) {
                GuiCircuit.this.iRed = -1;
                GuiCircuit.this.jRed = -1;
                GuiCircuit.this.paint = true;
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (GuiCircuit.this.clickMode && arg0.getButton() == 1) {
                System.out.println("Begin selection " + arg0.getX() + " " + arg0.getY());
                int x = 0;
                int y = 0;
                if (arg0.getSource() instanceof JLabel) {
                    x = ((JLabel)arg0.getSource()).getX();
                    y = ((JLabel)arg0.getSource()).getY();
                }
                GuiCircuit.this.startSelectX = x + arg0.getX();
                GuiCircuit.this.startSelectY = y + arg0.getY();
                GuiCircuit.this.stopSelectX = x + arg0.getX();
                GuiCircuit.this.stopSelectY = y + arg0.getY();
                GuiCircuit.this.paint = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            Object src = arg0.getSource();
            if (arg0.getButton() == 1) {
                if (GuiCircuit.this.clickMode) {
                    System.out.println("End selection " + GuiCircuit.this.startSelectX + " " + GuiCircuit.this.startSelectY + " " + GuiCircuit.this.stopSelectX + " " + GuiCircuit.this.stopSelectY);
                    if (GuiCircuit.this.startSelectX > GuiCircuit.this.stopSelectX) {
                        GuiCircuit.this.interchange('\u0000');
                    }
                    if (GuiCircuit.this.startSelectY > GuiCircuit.this.stopSelectY) {
                        GuiCircuit.this.interchange('\u0001');
                    }
                    Rectangle r = new Rectangle(GuiCircuit.this.startSelectX, GuiCircuit.this.startSelectY, GuiCircuit.this.stopSelectX - GuiCircuit.this.startSelectX, GuiCircuit.this.stopSelectY - GuiCircuit.this.startSelectY);
                    GuiCircuit.this.destroySelection();
                    int i = 0;
                    while (i < GuiCircuit.this.circuitLabels.length) {
                        int j = 0;
                        while (j < GuiCircuit.this.circuitLabels[0].length) {
                            Rectangle l = GuiCircuit.this.circuitLabels[i][j].getBounds();
                            if (r.contains(l)) {
                                GuiCircuit.this.rs.add(l);
                                GuiCircuit.this.is.add(i);
                                GuiCircuit.this.js.add(j);
                            }
                            ++j;
                        }
                        ++i;
                    }
                    GuiCircuit.this.paint = true;
                    GuiCircuit.this.startSelectX = -1;
                }
            } else {
                if (src instanceof JLabel) {
                    boolean insideSelectedZone = false;
                    Rectangle r = ((JLabel)src).getBounds();
                    int i = 0;
                    while (i < GuiCircuit.this.rs.size()) {
                        if (((Rectangle)GuiCircuit.this.rs.get(i)).contains(r)) {
                            insideSelectedZone = true;
                            break;
                        }
                        ++i;
                    }
                    if (insideSelectedZone) {
                        GuiCircuit.this.rightClickMenu.show(this.parent, r.x + arg0.getX(), r.y + arg0.getY());
                        GuiCircuit.this.relativeLine = GuiCircuit.this.iRed;
                        GuiCircuit.this.relativeColumn = GuiCircuit.this.jRed;
                    } else {
                        GuiCircuit.this.destroySelection();
                    }
                } else {
                    GuiCircuit.this.destroySelection();
                }
                GuiCircuit.this.paint = true;
            }
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
            if (GuiCircuit.this.clickMode) {
                int x = 0;
                int y = 0;
                if (arg0.getSource() instanceof JLabel) {
                    x = ((JLabel)arg0.getSource()).getX();
                    y = ((JLabel)arg0.getSource()).getY();
                }
                GuiCircuit.this.stopSelectX = x + arg0.getX();
                GuiCircuit.this.stopSelectY = y + arg0.getY();
                GuiCircuit.this.paint = true;
            }
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
        }
    }
}

