/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class AnalyzeDialog
extends JDialog
implements ActionListener,
Definitions {
    private static final long serialVersionUID = 1L;
    private List<JTextField> textFields;
    private JButton analyzeButton;
    private String parameters;
    private boolean approve;
    private JLabel message;

    public AnalyzeDialog(int nrParameters) {
        Singleton singleton = Singleton.getInstance();
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setPreferredSize(new Dimension(450, 100 + nrParameters * 30));
        int i = 0;
        while (i < nrParameters) {
            String labelName = i == 0 ? "Output : " : "Parameter " + (i + 2) + " :  ";
            JLabel l = singleton.createLabel(labelName, 50, 30 + i * 30, 200, 20, null, panel);
            l.setHorizontalAlignment(4);
            ++i;
        }
        this.textFields = new ArrayList<JTextField>();
        i = 0;
        while (i < nrParameters) {
            JTextField t = singleton.createTextField(10, 250, 30 + i * 30, 100, 20, panel);
            this.textFields.add(t);
            ++i;
        }
        this.analyzeButton = singleton.createButton("Submit", 200, 30 + nrParameters * 30, 100, 20, panel, this);
        this.message = Singleton.getInstance().createLabel("", 50, 60 + nrParameters * 30, 200, 20, MESSAGE_COLOR, panel);
        JScrollPane scrollBar = new JScrollPane(panel);
        scrollBar.setVerticalScrollBarPolicy(22);
        this.add(scrollBar);
        this.setPreferredSize(new Dimension(500, 300));
        this.setBounds(Main.fullSizeWidth / 2 - 250, Main.fullSizeHeight / 2 - 150, 500, 300);
        this.approve = false;
        this.setModal(true);
    }

    public String getData() {
        return this.parameters;
    }

    public boolean hasData() {
        return this.approve;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.analyzeButton)) {
            this.parameters = "";
            boolean error = false;
            int i = 0;
            while (i < this.textFields.size()) {
                if (this.textFields.get(i).getText().length() < 1) {
                    error = true;
                    break;
                }
                this.parameters = String.valueOf(this.parameters) + this.textFields.get(i).getText();
                this.parameters = String.valueOf(this.parameters) + " ";
                ++i;
            }
            if (!error) {
                this.approve = true;
                this.dispose();
            } else {
                this.message.setText("The input data is not correct");
            }
        }
    }
}

