/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class GuiAnalyze
extends Gui {
    private static final long serialVersionUID = 1L;
    private JTextArea textArea;
    private JScrollPane areaScrollPane;
    private JProgressBar progressBar;
    private int progress;
    private String name;
    private String exec;
    private String inputFile;
    private String parameters;
    private String progressFile;
    int ID;
    Process runtest;

    public GuiAnalyze(String name, int ID, String exec, String parameters) {
        System.out.println("Constructor simulation");
        this.progress = 0;
        this.textArea = new JTextArea();
        this.textArea.setBounds(150, 150, Main.fullSizeWidth - 260, Main.fullSizeHeight - 500);
        this.textArea.setFont(new Font("Arial", 0, 24));
        this.areaScrollPane = new JScrollPane(this.textArea);
        this.areaScrollPane.setVerticalScrollBarPolicy(22);
        this.areaScrollPane.setBounds(150, 150, Main.fullSizeWidth - 260, Main.fullSizeHeight - 500);
        this.add(this.areaScrollPane);
        this.textArea.append("The simulate is running...\n");
        this.textArea.append("Below is the progress of the simulation\n");
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setBounds(Main.fullSizeWidth / 2 - 100, Main.fullSizeHeight - 250, 200, 50);
        this.progressBar.setValue(this.progress);
        this.add(this.progressBar);
        this.ID = ID;
        this.name = name;
        this.exec = exec;
        this.parameters = parameters;
        this.initAnalyze();
        this.analyze();
        this.closeTaskItem.setEnabled(true);
    }

    private void analyze() {
        try {
            String nameOS = System.getProperty("os.name");
            String cmd = "";
            if (!nameOS.contains("Windows")) {
                cmd = "./";
            }
            cmd = String.valueOf(cmd) + this.exec + " ";
            cmd = String.valueOf(cmd) + this.inputFile + " " + this.parameters + this.progressFile;
            this.textArea.append(String.valueOf(cmd) + "\n");
            this.runtest = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.paint = true;
    }

    private void endAnalyze() {
        try {
            Scanner scanner = new Scanner(this.parameters);
            BufferedReader in = new BufferedReader(new FileReader(scanner.next()));
            String string = in.readLine();
            while (string != null) {
                this.textArea.append(String.valueOf(string) + "\n");
                string = in.readLine();
            }
            in.close();
            String cmd = "rm " + this.progressFile;
            this.runtest.waitFor();
            Runtime.getRuntime().exec(cmd);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.paint = true;
    }

    private void initAnalyze() {
        this.inputFile = String.valueOf(this.name.substring(0, this.name.length() - 3)) + "anlz";
        this.progressFile = String.valueOf(this.name.substring(0, this.name.length() - 4)) + this.ID + "." + "prg";
        this.inputFile = Singleton.getInstance().tranformName(this.inputFile);
        this.progressFile = Singleton.getInstance().tranformName(this.progressFile);
        this.paint = true;
    }

    @Override
    public void update() {
        BufferedReader in = null;
        int x = 0;
        if (this.paint) {
            this.repaint();
            this.paint = false;
        }
        if (this.progress < 100) {
            try {
                in = new BufferedReader(new FileReader(this.progressFile));
                Scanner scanner = new Scanner(in);
                while (scanner.hasNextInt()) {
                    x = scanner.nextInt();
                    if (x <= this.progress) continue;
                    this.progress = x;
                }
                in.close();
                if (this.progress == 100) {
                    this.endAnalyze();
                }
                this.progressBar.setValue(x);
                this.paint = true;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

