/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class Gui
extends JPanel
implements Definitions,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JToolBar toolbar;
    protected List<JButton> tools;
    protected List<BufferedImage> tiles;
    private JMenu menu;
    private JMenuBar menuBar;
    protected JMenuItem newItem;
    protected JMenuItem openItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem saveItem;
    protected JMenuItem exportItem;
    protected JMenuItem quitItem;
    protected JMenuItem closeTaskItem;
    protected JMenuItem zoomInItem;
    protected JMenuItem zoomOutItem;
    protected JMenuItem moveRight;
    protected JMenuItem moveLeft;
    protected JMenuItem moveUp;
    protected JMenuItem moveDown;
    protected JMenuItem theme1;
    protected JMenuItem theme2;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenuItem selectModeItem;
    protected JMenuItem insertCompItem;
    protected JMenu toolsMenu;
    protected List<JMenuItem> toolsMenuItems;
    JMenuItem runItem;
    protected List<JMenuItem> methodItems;
    protected List<Integer> nrParamPerMethod;
    protected List<String> execNamePerMethod;
    private JMenuItem helpItem;
    protected static JComboBox taskComboBox;
    protected boolean paint;

    public Gui() {
        this.initUI();
    }

    protected void initUI() {
        this.setLayout(null);
        this.setBackground(BACKGROUND_COLOR);
        this.toolbar = new JToolBar();
        this.toolbar.setBounds(0, 30, 50, Main.fullSizeHeight - 50);
        this.toolbar.setRollover(true);
        this.toolbar.setOrientation(1);
        this.createToolbar();
        this.createMenu();
        if (taskComboBox == null) {
            this.createTaskComboBox();
        } else {
            Main.guiList.get(Main.crt).remove(taskComboBox);
            this.add(taskComboBox);
        }
    }

    protected void createTaskComboBox() {
        taskComboBox = new JComboBox();
        taskComboBox.setBounds(Main.fullSizeWidth - 350, 50, 300, 20);
        taskComboBox.addActionListener(this);
        this.add(taskComboBox);
    }

    private void createMenu() {
        Singleton singleton = Singleton.getInstance();
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("File");
        this.menu.setMnemonic(65);
        this.newItem = singleton.createMenuItem("New", this.menu, this);
        this.newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.openItem = singleton.createMenuItem("Open", this.menu, this);
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.saveAsItem = singleton.createMenuItem("Save as", this.menu, this);
        this.saveAsItem.setEnabled(false);
        this.saveItem = singleton.createMenuItem("Save", this.menu, this);
        this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveItem.setEnabled(false);
        this.menu.addSeparator();
        this.exportItem = singleton.createMenuItem("Export", this.menu, this);
        this.exportItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.exportItem.setEnabled(false);
        this.menu.addSeparator();
        this.closeTaskItem = singleton.createMenuItem("Close current task", this.menu, this);
        this.closeTaskItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.closeTaskItem.setEnabled(false);
        this.quitItem = singleton.createMenuItem("Quit", this.menu, this);
        this.menuBar.add(this.menu);
        this.menu = new JMenu("View");
        this.menu.setMnemonic(66);
        this.zoomInItem = singleton.createMenuItem("Zoom in", this.menu, this);
        this.zoomInItem.setAccelerator(KeyStroke.getKeyStroke('='));
        this.zoomInItem.setEnabled(false);
        this.zoomOutItem = singleton.createMenuItem("Zoom out", this.menu, this);
        this.zoomOutItem.setAccelerator(KeyStroke.getKeyStroke('-'));
        this.zoomOutItem.setEnabled(false);
        this.menu.addSeparator();
        this.moveLeft = singleton.createMenuItem("Move left", this.menu, this);
        this.moveLeft.setAccelerator(KeyStroke.getKeyStroke('a'));
        this.moveLeft.setEnabled(false);
        this.moveRight = singleton.createMenuItem("Move right", this.menu, this);
        this.moveRight.setAccelerator(KeyStroke.getKeyStroke('d'));
        this.moveRight.setEnabled(false);
        this.moveUp = singleton.createMenuItem("Move up", this.menu, this);
        this.moveUp.setAccelerator(KeyStroke.getKeyStroke('w'));
        this.moveUp.setEnabled(false);
        this.moveDown = singleton.createMenuItem("Move down", this.menu, this);
        this.moveDown.setAccelerator(KeyStroke.getKeyStroke('s'));
        this.moveDown.setEnabled(false);
        this.menu.addSeparator();
        JMenu themeMenu = new JMenu("Choose theme");
        this.theme1 = singleton.createMenuItem("Gray/White theme", themeMenu, this);
        this.theme1.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        this.theme1.setEnabled(false);
        this.theme2 = singleton.createMenuItem("DNA theme", themeMenu, this);
        this.theme2.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        this.theme2.setEnabled(false);
        this.menu.add(themeMenu);
        this.menuBar.add(this.menu);
        this.menu = new JMenu("Edit");
        this.menu.setMnemonic(67);
        this.undoItem = singleton.createMenuItem("Undo", this.menu, this);
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.undoItem.setEnabled(false);
        this.redoItem = singleton.createMenuItem("Redo", this.menu, this);
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.redoItem.setEnabled(false);
        this.selectModeItem = singleton.createMenuItem("Click mode", this.menu, this);
        this.selectModeItem.setAccelerator(KeyStroke.getKeyStroke('c'));
        this.selectModeItem.setEnabled(false);
        this.insertCompItem = singleton.createMenuItem("Insert component", this.menu, this);
        this.insertCompItem.setAccelerator(KeyStroke.getKeyStroke('i'));
        this.insertCompItem.setEnabled(false);
        this.menuBar.add(this.menu);
        this.toolsMenu = new JMenu("Tools");
        this.toolsMenu.setMnemonic(68);
        this.createToolsMenu();
        this.menuBar.add(this.toolsMenu);
        this.menu = new JMenu("Analyze");
        this.menu.setMnemonic(69);
        this.methodItems = new ArrayList<JMenuItem>();
        this.execNamePerMethod = new ArrayList<String>();
        this.nrParamPerMethod = new ArrayList<Integer>();
        this.createMethod("Fault Tolerance", "runtest", 3);
        this.menuBar.add(this.menu);
        this.menu = new JMenu("Simulate");
        this.menu.setMnemonic(70);
        this.runItem = singleton.createMenuItem("Run", this.menu, this);
        this.runItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.runItem.setEnabled(false);
        this.menuBar.add(this.menu);
        this.menu = new JMenu("Help");
        this.menu.setMnemonic(71);
        this.helpItem = singleton.createMenuItem("Readme", this.menu, this);
        this.menuBar.add(this.menu);
        this.menuBar.setBounds(0, 0, Main.fullSizeWidth, 30);
        this.add(this.menuBar);
    }

    public void createMethod(String menuName, String execName, int nrParameters) {
        JMenuItem methodItem = Singleton.getInstance().createMenuItem(menuName, this.menu, this);
        methodItem.setEnabled(false);
        this.methodItems.add(methodItem);
        this.execNamePerMethod.add(execName);
        this.nrParamPerMethod.add(nrParameters);
    }

    public void createToolsMenu() {
        if (this.toolsMenu != null) {
            this.toolsMenu.removeAll();
        }
        this.addToolsToMenu("Blank tile", this.toolsMenu, 0, 1);
        this.addToolsToMenu("Wired tiles", this.toolsMenu, 3, 15);
        this.addToolsToMenu("Transistor tiles", this.toolsMenu, 1, 3);
        this.addToolsToMenu("Voltage tiles", this.toolsMenu, 15, 17);
        this.addToolsToMenu("IO tiles", this.toolsMenu, 17, 19);
    }

    private void addToolsToMenu(String string, JMenu menu, int start, int stop) {
        JMenu auxMenu = new JMenu(string);
        int i = start;
        while (i < stop) {
            auxMenu.add(this.toolsMenuItems.get(i));
            ++i;
        }
        menu.add(auxMenu);
    }

    public void createToolbar() {
        this.tiles = Singleton.getInstance().createTiles();
        if (this.toolbar != null) {
            this.toolbar.removeAll();
        }
        this.tools = new ArrayList<JButton>();
        this.toolsMenuItems = new ArrayList<JMenuItem>();
        int i = 0;
        while (i < 20) {
            Image im = this.tiles.get(i).getScaledInstance(25, 25, 1);
            JButton button = new JButton(new ImageIcon(im));
            button.addActionListener(this);
            this.toolbar.add(button);
            this.toolbar.addSeparator();
            this.tools.add(button);
            JMenuItem menuItem = new JMenuItem(new ImageIcon(im));
            menuItem.addActionListener(this);
            this.toolsMenuItems.add(menuItem);
            ++i;
        }
        this.add(this.toolbar);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        if (source.equals(this.newItem)) {
            System.out.println("New circuit creating");
            NewFileDialog newFileDialog = new NewFileDialog();
            newFileDialog.setVisible(true);
            if (newFileDialog.hasData()) {
                List<Integer> dimensions = newFileDialog.getData();
                this.createTask(dimensions.get(1), dimensions.get(0));
            }
        } else if (source.equals(this.openItem)) {
            System.out.println("Open");
            String fileName = this.openPopupWindow();
            if (fileName != null) {
                try {
                    BufferedReader in = new BufferedReader(new FileReader(fileName));
                    this.createTask(fileName);
                    in.close();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        } else if (source.equals(taskComboBox)) {
            Main.guiList.get(Main.crt).remove(taskComboBox);
            Main.crt = taskComboBox.getSelectedIndex() + 1;
            Main.guiList.get(Main.crt).signal();
            Main.x = true;
            Main.guiList.get(Main.crt).add(taskComboBox);
        } else if (source.equals(this.quitItem)) {
            System.exit(0);
        } else if (source.equals(this.closeTaskItem)) {
            System.out.println("Close current task action " + Main.crt);
            taskComboBox.removeItemAt(taskComboBox.getSelectedIndex());
            Main.guiList.remove(--Main.crt + 1);
            this.paint = true;
            Main.x = true;
        } else if (source.equals(this.helpItem)) {
            this.createHelp();
        }
    }

    protected String openPopupWindow() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".tnn") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "TNN Files";
            }
        });
        int r = chooser.showOpenDialog(this);
        if (r == 0) {
            return chooser.getSelectedFile().getPath();
        }
        return null;
    }

    private void createTask(int circuitWidth, int circuitHeight) {
        System.out.println("Create task action");
        Main.guiList.add(new GuiCircuit(circuitWidth, circuitHeight));
        this.updateMain("Untitled" + Singleton.getInstance().getNrUntitled());
        Singleton.getInstance().setNrUntitled(Singleton.getInstance().getNrUntitled() + 1);
    }

    private void createTask(String fileName) {
        System.out.println("Create task action");
        Main.guiList.add(new GuiCircuit(fileName));
        this.updateMain(Singleton.getInstance().tranformName(fileName));
    }

    private void createHelp() {
        System.out.println("Create help");
        Main.guiList.add(new GuiHelp());
        this.updateMain("help");
    }

    private void updateMain(String taskName) {
        Main.crt = Main.guiList.size() - 1;
        Main.x = true;
        taskComboBox.addItem(taskName);
        taskComboBox.setSelectedIndex(taskComboBox.getItemCount() - 1);
        System.out.println("Main updated");
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public void update() {
        if (this.paint) {
            this.repaint();
            this.paint = false;
        }
    }

    protected void signal() {
        this.paint = true;
    }
}

