/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class GuiSimulation
extends Gui {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private JScrollPane tableVerticalScroll;
    private JLabel messageLabel;
    private char messPoints;
    private String name;
    private String inputFile;
    private String outputFile;
    private List<String> inputNames;
    private int nrInputs;
    private int nrOutputs;
    int ID;
    private boolean end;

    public GuiSimulation(String name, int ID, List<String> outputs, List<String> inputs) {
        System.out.println(outputs.toString());
        System.out.println(inputs.toString());
        this.nrInputs = inputs.size();
        this.nrOutputs = outputs.size();
        Object[] columns = new String[outputs.size() + inputs.size()];
        int i = 0;
        while (i < columns.length) {
            columns[i] = i < inputs.size() ? inputs.get(i) : outputs.get(i - inputs.size());
            ++i;
        }
        int nrRows = 1;
        int i2 = 0;
        while (i2 < inputs.size()) {
            nrRows *= 2;
            ++i2;
        }
        Object[][] rows = new Integer[nrRows][columns.length];
        this.inputNames = new ArrayList<String>();
        int i3 = 0;
        while (i3 < rows.length) {
            int x = i3;
            int y = nrRows / 2;
            String inName = "";
            int j = 0;
            while (j < this.nrInputs) {
                rows[i3][j] = x / y;
                inName = String.valueOf(inName) + x / y;
                x %= y;
                y /= 2;
                ++j;
            }
            this.inputNames.add(inName);
            ++i3;
        }
        System.out.println(this.inputNames.toString());
        System.out.println("Constructor simulation");
        this.table = new JTable(rows, columns);
        this.table.setBounds(150, 150, Main.fullSizeWidth - 260, Main.fullSizeHeight - 250);
        ColoredTableCellRenderer inputRenderer = new ColoredTableCellRenderer(Color.yellow);
        ColoredTableCellRenderer outputRenderer = new ColoredTableCellRenderer(Color.green);
        int i4 = 0;
        while (i4 < columns.length) {
            if (i4 < inputs.size()) {
                this.table.getColumnModel().getColumn(i4).setCellRenderer(inputRenderer);
            } else {
                this.table.getColumnModel().getColumn(i4).setCellRenderer(outputRenderer);
            }
            ++i4;
        }
        this.tableVerticalScroll = new JScrollPane(this.table);
        this.tableVerticalScroll.setVerticalScrollBarPolicy(20);
        this.tableVerticalScroll.setHorizontalScrollBarPolicy(30);
        this.tableVerticalScroll.setBounds(150, 150, Main.fullSizeWidth - 260, Main.fullSizeHeight - 250);
        this.add(this.tableVerticalScroll);
        this.messageLabel = Singleton.getInstance().createLabel("Simulating...", Main.fullSizeWidth / 2 - 75, 100, 150, 20, Color.WHITE, this);
        this.messPoints = (char)3;
        this.name = name;
        this.ID = ID;
        this.initSimulation();
        this.simulate();
        this.end = false;
        this.closeTaskItem.setEnabled(true);
    }

    private void simulate() {
        try {
            String nameOS = System.getProperty("os.name");
            String cmd = "sim.bat ";
            if (!nameOS.contains("Windows")) {
                cmd = "./sim.sh ";
            }
            cmd = String.valueOf(cmd) + this.inputFile + " " + this.outputFile + " " + this.outputFile + this.ID + ".prg";
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.paint = true;
    }

    private void initSimulation() {
        this.inputFile = String.valueOf(this.name.substring(0, this.name.length() - 3)) + "anlz";
        this.outputFile = String.valueOf(this.name.substring(0, this.name.length() - 3)) + "sim";
        this.inputFile = Singleton.getInstance().tranformName(this.inputFile);
        this.outputFile = Singleton.getInstance().tranformName(this.outputFile);
        this.paint = true;
    }

    private void endSimulation() {
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.outputFile));
            Scanner scanner = new Scanner(in);
            int i = 0;
            int line = -1;
            while (scanner.hasNext()) {
                String string = scanner.next();
                if (i == 1) {
                    line = this.inputNames.indexOf(string);
                } else if (i > 1 && i % 2 == 1) {
                    Scanner sc = new Scanner(string);
                    int x = sc.nextInt();
                    this.table.setValueAt(new Integer(x), line, this.nrInputs + (i / 2 - 1));
                }
                if (i == this.nrOutputs * 2 + 2) {
                    i = -1;
                }
                ++i;
            }
            this.end = true;
            this.paint = true;
            in.close();
            this.messageLabel.setText("Simulation results:");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update() {
        if (this.paint) {
            this.repaint();
            this.paint = false;
        }
        if (!this.end) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(String.valueOf(this.outputFile) + this.ID + ".prg"));
                this.endSimulation();
                in.close();
                String cmd = "rm " + this.outputFile + this.ID + ".prg";
                Runtime.getRuntime().exec(cmd);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!this.end) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.messPoints = (char)(this.messPoints + '\u0001');
                if (this.messPoints == '\u0004') {
                    this.messPoints = '\u0001';
                }
                String message = "Simulating";
                int i = 0;
                while (i < this.messPoints) {
                    message = String.valueOf(message) + ".";
                    ++i;
                }
                this.messageLabel.setText(message);
            }
        }
    }

    class ColoredTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private Color color;

        public ColoredTableCellRenderer(Color color) {
            this.color = color;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            this.setEnabled(table == null || table.isEnabled());
            this.setBackground(this.color);
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            return this;
        }
    }
}

