/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTextField;

public class Singleton
implements Definitions {
    private static final Singleton INSTANCE = new Singleton();
    PdfExporter pdfExporter;
    private AudioClip insertSound;
    private AudioClip deleteSound;
    private int nrUntitled;
    private List<Theme> themes;
    private int crtThemeIndex;
    private Theme crtTheme;

    private Singleton() {
        try {
            this.pdfExporter = new PdfExporter();
            URL url = this.getClass().getResource("sounds/insert.wav");
            this.insertSound = Applet.newAudioClip(url);
            url = this.getClass().getResource("sounds/delete.wav");
            this.deleteSound = Applet.newAudioClip(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nrUntitled = 1;
        this.themes = new ArrayList<Theme>();
        this.themes.add(new Theme("images/theme0-tileBackground.png", Color.BLACK, "images/theme0-circuitBackground.png", Color.GRAY));
        this.themes.add(new Theme("images/theme1-tileBackground.png", Color.BLACK, "images/theme1-circuitBackground.png", Color.GRAY));
        this.crtThemeIndex = 1;
        this.crtTheme = this.themes.get(this.crtThemeIndex);
    }

    public static Singleton getInstance() {
        return INSTANCE;
    }

    public JMenuItem createMenuItem(String name, JComponent parent, ActionListener al) {
        JMenuItem menuItem = new JMenuItem(name);
        menuItem.addActionListener(al);
        parent.add(menuItem);
        return menuItem;
    }

    public JTextField createTextField(int size, int x, int y, int width, int height, Container parent) {
        JTextField textField = new JTextField(size);
        textField.setBounds(x, y, width, height);
        parent.add(textField);
        return textField;
    }

    public JButton createButton(String name, int x, int y, int width, int height, Container parent, ActionListener al) {
        JButton button = new JButton(name);
        button.setBounds(x, y, width, height);
        button.addActionListener(al);
        parent.add(button);
        return button;
    }

    public JLabel createLabel(String text, int x, int y, int width, int height, Color color, Container parent) {
        JLabel label = new JLabel();
        label.setBounds(x, y, width, height);
        if (color != null) {
            label.setForeground(color);
        }
        label.setText(text);
        parent.add(label);
        return label;
    }

    public JComboBox createComboBox(int x, int y, int width, int height, Container parent) {
        JComboBox comboBox = new JComboBox();
        comboBox.setBounds(x, y, width, height);
        parent.add(comboBox);
        return comboBox;
    }

    public String tranformName(String string) {
        string = string.substring(string.lastIndexOf(92) + 1);
        string = string.substring(string.lastIndexOf(47) + 1);
        return string;
    }

    public BufferedImage createTextImage(String text) {
        BufferedImage image = this.createBasic(this.crtTheme.getTileBackground(), this.crtTheme.getCircuitBackground());
        Graphics2D g = image.createGraphics();
        g.setColor(this.crtTheme.getWireColor());
        g.setFont(new Font("SansSerif", 1, 72));
        g.drawString(text, 100 - text.length() * 50 / 2, 118);
        return image;
    }

    public BufferedImage createBasic(String background, String border) {
        BufferedImage image = null;
        try {
            URL url = this.getClass().getResource(border);
            image = ImageIO.read(url);
            Graphics2D g = image.createGraphics();
            url = this.getClass().getResource(background);
            BufferedImage img = ImageIO.read(url);
            g.drawImage(img, 2, 2, img.getWidth() - 4, img.getHeight() - 4, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    private BufferedImage createWired(int drawing) {
        BufferedImage image = this.createBasic(this.crtTheme.getTileBackground(), this.crtTheme.getCircuitBackground());
        Graphics2D g = image.createGraphics();
        g.setColor(this.crtTheme.getWireColor());
        if (drawing / 8 == 1) {
            g = this.drawVerticalUp(g);
            drawing %= 8;
        }
        if (drawing / 4 == 1) {
            g = this.drawHorizontalRight(g);
            drawing %= 4;
        }
        if (drawing / 2 == 1) {
            g = this.drawVerticalDown(g);
            drawing %= 2;
        }
        if (drawing > 0) {
            g = this.drawHorizontalLeft(g);
        }
        return image;
    }

    private BufferedImage createTransistor(String text) {
        BufferedImage image = this.createBasic(this.crtTheme.getTileBackground(), this.crtTheme.getCircuitBackground());
        Graphics2D g = image.createGraphics();
        g.setColor(this.crtTheme.getSemiconductorColor());
        g = this.drawVerticalUp(g);
        g = this.drawVerticalDown(g);
        g.setColor(this.crtTheme.getWireColor());
        g = this.drawHorizontalLeft(g);
        g.setFont(new Font("SansSerif", 1, 72));
        g.drawString(text, 136, 82);
        return image;
    }

    private Graphics2D drawHorizontalLeft(Graphics2D g) {
        int halWireWidth = 7;
        int excess = 22;
        int length = 100;
        int border = 2;
        g.fillRect(border, length - halWireWidth, length + excess - border, 15);
        return g;
    }

    private Graphics2D drawHorizontalRight(Graphics2D g) {
        int halWireWidth = 7;
        int excess = 22;
        int length = 100;
        int border = 2;
        g.fillRect(length - excess, length - halWireWidth, length + excess - border, 15);
        return g;
    }

    private Graphics2D drawVerticalUp(Graphics2D g) {
        int halWireWidth = 7;
        int excess = 22;
        int length = 100;
        int border = 2;
        g.fillRect(length - halWireWidth, border, 15, length + excess - border);
        return g;
    }

    private Graphics2D drawVerticalDown(Graphics2D g) {
        int halWireWidth = 7;
        int excess = 22;
        int length = 100;
        int border = 2;
        g.fillRect(length - halWireWidth, length - excess, 15, length + excess - border);
        return g;
    }

    public List<BufferedImage> createTiles() {
        int[] vector = new int[]{5, 10, 3, 9, 12, 6, 13, 7, 11, 14, 15};
        ArrayList<BufferedImage> tiles = new ArrayList<BufferedImage>();
        BufferedImage image = this.createBasic(this.crtTheme.getTileBackground(), this.crtTheme.getCircuitBackground());
        tiles.add(image);
        image = this.createTransistor("p");
        tiles.add(image);
        image = this.createTransistor("n");
        tiles.add(image);
        int i = 0;
        while (i < vector.length) {
            image = this.createWired(vector[i]);
            tiles.add(image);
            ++i;
        }
        image = this.createBasic(this.crtTheme.getTileBackground(), this.crtTheme.getCircuitBackground());
        Graphics2D g = image.createGraphics();
        g.setColor(this.crtTheme.getWireColor());
        g.fillRect(93, 2, 15, 50);
        g.fillRect(93, 152, 15, 50);
        g = this.drawHorizontalLeft(g);
        g = this.drawHorizontalRight(g);
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(15.0f, 1, 1));
        g.drawArc(50, 50, 100, 100, 90, 180);
        g.setStroke(oldStroke);
        tiles.add(image);
        String[] strings = new String[]{"Vcc", "Vdd", "In", "Out"};
        int i2 = 0;
        while (i2 < strings.length) {
            image = this.createTextImage(strings[i2]);
            tiles.add(image);
            ++i2;
        }
        try {
            URL url = this.getClass().getResource("images/19.png");
            image = ImageIO.read(url);
            tiles.add(image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        image = this.createBasic(this.crtTheme.getCircuitBackground(), this.crtTheme.getTileBackground());
        tiles.add(image);
        return tiles;
    }

    public void changeTheme() {
        this.crtTheme = this.themes.get(this.crtThemeIndex);
        int i = 0;
        while (i < Main.guiList.size()) {
            System.out.println(i);
            Gui gui = Main.guiList.get(i);
            gui.createToolbar();
            gui.createToolsMenu();
            if (gui instanceof GuiCircuit) {
                ((GuiCircuit)gui).changeTheme();
            }
            ++i;
        }
    }

    public void export(String file, Image awtImg, int height, int width) {
        this.pdfExporter.exportToPdf(file, awtImg, height, width);
    }

    public void insertSoundPlay() {
        this.insertSound.play();
    }

    public void deleteSoundPlay() {
        this.deleteSound.play();
    }

    public int getNrUntitled() {
        return this.nrUntitled;
    }

    public void setNrUntitled(int nrUntitled) {
        this.nrUntitled = nrUntitled;
    }

    public int getCrtThemeIndex() {
        return this.crtThemeIndex;
    }

    public void setCrtThemeIndex(int crtThemeIndex) {
        this.crtThemeIndex = crtThemeIndex;
    }
}

