/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

/**
 * 
 * @author Daniel Pletea
 *
 */
public class NewFileDialog extends JDialog implements ActionListener, Definitions{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	// the boolean which tells if the input of the user is valid
	private boolean APPROVE_OPTION;
     
	// the JComponents which will be used in this dialog window
    private JTextField widthTF, heightTF; 
	private JButton newButton;
	private JLabel message;
    
	// the circuit width and height
	int circuitWidth, circuitHeight;
	
    public NewFileDialog() {
    	
    	// 
    	setLayout(null);
        
        // a label with width
    	Singleton.getInstance().createLabel("Width:", 50,50,100,20, null, this);
        
    	// a label with height
        Singleton.getInstance().createLabel("Height:", 50,100,100,20, null, this);
        
        // textbox for width
        widthTF = new JTextField(10);
        widthTF.setBounds(150,50,100,20);
        add(widthTF);
        
        // textbox for height
        heightTF = new JTextField(10);
        heightTF.setBounds(150,100,100,20);
        add(heightTF);
        
        // button for submitting the information
        newButton = new JButton("New circuit");
        newButton.setBounds(100, 150, 100, 20);
        newButton.addActionListener(this);
        add(newButton);
        
        // a message for the user
        message = Singleton.getInstance().createLabel("", 50, 180, 200, 20, MESSAGE_COLOR, this);
        
        // set size
        setPreferredSize(new Dimension(300, 300));
        setBounds(Main.fullSizeWidth / 2 - 150, Main.fullSizeHeight / 2 - 150, 300, 300);
        
        APPROVE_OPTION = false;
        setModal(true);        // will wait until dispose() before exiting
    }
     
    /**
     * return the input from the user
     * @return
     */
    public List<Integer> getData() {
    	List<Integer> dimensions = new ArrayList<Integer>();
    	
    	dimensions.add(circuitHeight);
        dimensions.add(circuitWidth); 
        
        return dimensions;
    }
    
    /**
     * this function tells if the data from the user is valid
     * @return
     */
    public boolean hasData()
    {
    	return APPROVE_OPTION;
    }
     
    @Override
    public void actionPerformed(ActionEvent e) {
        if(e.getSource().equals(newButton))
        {
        	Scanner sc;
			
			sc = new Scanner(widthTF.getText());
			
			if(!sc.hasNextInt()) message.setText("The input data is not correct");
			else {
				circuitWidth = sc.nextInt();
				sc = new Scanner(heightTF.getText());
				
				// valdiate if circuitWidth is at least 1
				if(!sc.hasNextInt() || circuitWidth < 1) message.setText("The input data is not correct");
				else {
					circuitHeight = sc.nextInt();
					
					// validate if circuitHeight is at least 1
					if(circuitHeight < 1) message.setText("The input data is not correct");
					else {
						APPROVE_OPTION = true;
						dispose();
					}
				}
			}
		}    
    }
}
