/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Scanner;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

/**
 * this class is used for asking the user about how many rows/columns he wants
 * to insert
 * 
 * @author Daniel Pletea
 * 
 */
public class InsertDialog extends JDialog implements ActionListener,
		Definitions {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// this boolean is set true when the input from the user is validated
	private boolean APPROVE_OPTION;

	// the JComponents used for this dialog window
	private JTextField howManyTextF;
	private JButton submitInsertButton;
	private JLabel message;

	// this is the data that will be returned in the program
	int howMany;

	/**
	 * constructor
	 */
	public InsertDialog() {

		JLabel l;
		Singleton singleton = Singleton.getInstance();

		//
		setLayout(null);

		// a label with width
		l = singleton.createLabel("How many ?  ", 150, 50, 100, 20, null, this);
		l.setHorizontalAlignment(SwingConstants.RIGHT);

		// the text box where the users types the number of the rows or columns
		howManyTextF = singleton.createTextField(10, 250, 50, 100, 20, this);

		// the button for submitting the number of rows/columns
		submitInsertButton = singleton.createButton("Submit", 200, 150, 100,
				20, this, this);

		// here is the message for the user
		message = singleton.createLabel("Inserting", 150, 200, 200, 20,
				MESSAGE_COLOR, this);

		// setting size
		setPreferredSize(new Dimension(500, 300));
		setBounds(Main.fullSizeWidth / 2 - 250, Main.fullSizeHeight / 2 - 150,
				500, 300);

		// the boolean
		APPROVE_OPTION = false;

		setModal(true); // will wait until dispose() before exiting
	}

	/**
	 * returns the data from this window dialog
	 * 
	 * @return
	 */
	public int getData() {
		return howMany;
	}

	/**
	 * this functions tells if the input from the user is ok
	 * 
	 * @return
	 */
	public boolean hasData() {
		return APPROVE_OPTION;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(submitInsertButton)) {
			Scanner sc;

			// get the input from the user
			sc = new Scanner(howManyTextF.getText());

			if (!sc.hasNextInt())
				message.setText("The input data is not correct");
			else {
				howMany = sc.nextInt();

				// the number of the rows must at least 1
				if (howMany < 1)
					message.setText("The input data is not correct");
				else {

					// if everything ok set the APPROVE_OPTION true
					APPROVE_OPTION = true;

					dispose(); // exiting
				}
			}
		}

	}
}
