#ifndef TNODE_H
#define TNODE_H
#include<iostream>
#include<vector>
using namespace std;


const int NODE_TYPE_JUNCTION = 1;
const int NODE_TYPE_TRANSISTOR_P=2;
const int NODE_TYPE_TRANSISTOR_N=3; 
const int NODE_TYPE_INPUT=4;
const int NODE_TYPE_OUTPUT=5;
const int NODE_TYPE_VDD =6;
const int NODE_TYPE_VCC =7;
const int NODE_TYPE_EMPTY =0;
const int NODE_TYPE_UNKNOWN = -1;



const int TRANSISTOR_P=0;
const int TRANSISTOR_N=1;
const int TEMP_EDGE=-1;
const int STRENGTH_0=0;
const int STRENGTH_K=1;
const int STRENGTH_Y=2;
const int STRENGTH_INF=3;

class Edge {
	public:
	int dest;  // TNode which the other end of transistor is connected to
	int gate; // TNode which this transistor is connected to by gate
	int type;  //Transistor type
    int transistor; // Transistor id
    Edge(int _dest,int _type, int _gate) {
        dest=_dest;
        gate=_gate;
        type=_type;
        transistor=-1;
    }
    Edge(int _dest, int _type, int _gate, int _transistor_id) {
        dest=_dest;
        gate=_gate;
        type=_type;
        transistor=_transistor_id;

    }

};

class TNode {
	public: 

     int graph_id; // id in the graph
     int circuit_id; // id in the circuit
     int type; // node type
     int strength;
     vector<Edge> edges;
    
    bool found;
    bool done;
    int state,q,u,d;
    int newstate;

   vector<int> gate_edges;

    TNode(int graph_id, int circuit_id, int type ) {
        this->graph_id=graph_id;
        this->circuit_id=circuit_id;
        this->type=type;
        done=true;
        if(type==NODE_TYPE_INPUT||type==NODE_TYPE_VDD||type==NODE_TYPE_VCC) strength=STRENGTH_INF;
        else strength=STRENGTH_K;
        if(type==NODE_TYPE_VDD) state=1;
        if(type==NODE_TYPE_VCC) state=0;
    }
    void add(int dest, int type, int gate) {
        edges.push_back(Edge(dest,type,gate));
    }
    void add(int dest, int type, int gate, int graphid) {
        edges.push_back(Edge(dest,type,gate,graphid));
    }
    int nstate() {
    	if(u==STRENGTH_0) return 0;
        if(d==STRENGTH_0) return 1;
        return -1;
    }

    void add_gate(int node) {
        gate_edges.push_back(node);
    }
    bool has_edge(int node) {
        for(int i=0;i<edges.size();i++) {
            if(edges[i].dest==node) return true;
        }
        return false;
    }
    bool has_gate_edge(int node) {
        for(int i=0;i<gate_edges.size();i++) {
            if(gate_edges[i]==node) return true;
        }
        return false;
    }
    



    void remove_edge(int node) {
    	bool move=false;
        for(int i=0;i<edges.size();i++) {
            if(move) {
                edges[i-1]=edges[i];
            }
            if(edges[i].dest==node) move=true;
        }
        
        if(move) edges.pop_back();
        
 //       else cout<<"???\n";
    }
    void remove_gate_edge(int node) {
    	bool move=false;
        for(int i=0;i<gate_edges.size();i++) {
            if(move) {
                gate_edges[i-1]=gate_edges[i];
            }
            if(gate_edges[i]==node) move=true;
        }
        
        gate_edges.pop_back();

     }
     /*
     void debug_print() {
        cout<<"TNode: "<<graph_id<<" (type "<<type<<")"<<endl;
        cout<<"Connected to: ";
        for(int i=0;i<edges.size();i++) {
            cout<<edges[i]<<",";
        }

        cout<<endl;
        if(gate_edges.size()==0) return;
        cout<<"Gate-connected to: ";
        for(int i=0;i<gate_edges.size();i++) {
            cout<<gate_edges[i]<<",";
        }

        cout<<endl;
     }*/

};


#endif
