/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.awt.Font;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;


/**
 * this class is created for creating a new gui for help
 * 
 * @author Daniel Pletea
 * 
 */
public class GuiHelp extends Gui {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	JTextArea textArea;
	JScrollPane areaScrollPane;
	
	public GuiHelp() {
		// creating the visual stuff
		textArea = new JTextArea();
		textArea.setBounds(150, 150, Main.fullSizeWidth - 260,
				Main.fullSizeHeight - 500);
		textArea.setFont(new Font("Arial", 0, 24));

		// create a scroll for the textArea
		areaScrollPane = new JScrollPane(textArea);
		areaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		areaScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		areaScrollPane.setBounds(150, 150, Main.fullSizeWidth - 260,
				Main.fullSizeHeight - 250);
		this.add(areaScrollPane);
		
		BufferedReader in;
		try {
			in = new BufferedReader(new FileReader("readme"));
			String str = in.readLine();
			while(str != null)
			{
				textArea.append(str + "\n");
				str = in.readLine();
			}
			
			in.close();
		
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}		
	}
}
