/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.util.logging.Level;

/**
 * 
 * @author Daniel Pletea
 *
 */
public class StdOutErrLevel extends Level {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private StdOutErrLevel(String name, int value) {
        super(name, value);
    }

    public static Level STDOUT =
        new StdOutErrLevel("STDOUT", Level.INFO.intValue()+53);
    public static Level STDERR =
        new StdOutErrLevel("STDERR", Level.INFO.intValue()+54);

    protected Object readResolve()
        throws ObjectStreamException {
        if (this.intValue() == STDOUT.intValue())
            return STDOUT;
        if (this.intValue() == STDERR.intValue())
            return STDERR;
        throw new InvalidObjectException("Unknown instance :" + this);
    }       

}
