/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.awt.event.ActionListener;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/**
 * 
 * @author Daniel Pletea
 *
 */
class RightClickMenu extends JPopupMenu {
   
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	// copy/paste items
	private JMenuItem copyItem;
    private JMenuItem cutItem;
    private JMenuItem pasteItem;
    
    // inserting and removing rows items
    private JMenuItem insertRowsAbove;
    private JMenuItem insertRowsBelow;
    private JMenuItem removeRowItem;
    private JMenuItem deleteRowItem;
    
    // inserting and removing columns items
    private JMenuItem insertColumnsAbove;
    private JMenuItem insertColumnsBelow;
    private JMenuItem removeColumnItem;
    private JMenuItem deleteColumnItem;

    // delete item
    private JMenuItem deleteItem;
    
    public RightClickMenu(ActionListener al){
    	
    	Singleton single = Singleton.getInstance();

    	// create copy/paste items
    	copyItem = single.createMenuItem("Copy", this, al);
        cutItem = single.createMenuItem("Cut", this, al);
        pasteItem = single.createMenuItem("Paste", this, al);
        
        // create inserting and removing rows items
        JMenu insertRowMenu = new JMenu("Rows");
        insertRowsAbove = single.createMenuItem("Insert rows above", insertRowMenu, al);
        insertRowsBelow = single.createMenuItem("Insert rows below", insertRowMenu, al);
        removeRowItem = single.createMenuItem("Remove row", insertRowMenu, al);
        deleteRowItem = single.createMenuItem("Delete row", insertRowMenu, al);
        add(insertRowMenu);
        
        // create inserting and removing columns items
        JMenu insertColumnMenu = new JMenu("Columns");
        insertColumnsAbove = single.createMenuItem("Insert Columns left", insertColumnMenu, al);
        insertColumnsBelow = single.createMenuItem("Insert Columns right", insertColumnMenu, al);
        removeColumnItem = single.createMenuItem("Remove column", insertColumnMenu, al);
        deleteColumnItem = single.createMenuItem("Delete column", insertColumnMenu, al);
        add(insertColumnMenu);
        
        deleteItem = single.createMenuItem("Delete", this, al);        
        
    }
    
    public JMenuItem getCopyItem()
    {
    	return copyItem;
    }
    
    public JMenuItem getCutItem()
    {
    	return cutItem;
    }
    
    public JMenuItem getPasteItem()
    {
    	return pasteItem;
    }
    public JMenuItem getInsertRowsAbove()
    {
    	return insertRowsAbove;
    }
    
    public JMenuItem getInsertRowsBelow()
    {
    	return insertRowsBelow;
    }
    
    public JMenuItem getRemoveRowItem()
    {
    	return removeRowItem;
    }
    
    public JMenuItem getDeleteRowItem()
    {
    	return deleteRowItem;
    }
    
    public JMenuItem getInsertColumnsLeft()
    {
    	return insertColumnsAbove;
    }
    
    public JMenuItem getInsertColumnsRight()
    {
    	return insertColumnsBelow;
    }
    
    public JMenuItem getRemoveColumnItem()
    {
    	return removeColumnItem;
    }
    
    public JMenuItem getDeleteColumnItem()
    {
    	return deleteColumnItem;
    }
    
    public JMenuItem getDeleteItem()
    {
    	return deleteItem;
    }
}
