/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

import javax.swing.JFrame;
import javax.swing.JPanel;

/**
 * 
 * @author Daniel Pletea
 *
 */

public class Main extends JFrame implements ActionListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private JPanel panel;
	
	static int crt;											// points to the curent Gui	
	static boolean x;								// tells if the crt was changed	
	static boolean quit = false;
	public static List<Gui> guiList = new ArrayList<Gui>();		// the lists of guis
	
	public static int fullSizeWidth;			// the full height of the window
	public static int fullSizeHeight;			// the full width of the window
	public static int height;					// the height of the window
	public static int width;					// the width of the window
	
	public static int pasteComponent[][];
	public static List<Object> pasteInputs;
	public static List<Object> pasteOutputs;
	
	@SuppressWarnings("unused")
	public Main() {
		
		// initialize logging to go to rolling log file
        LogManager logManager = LogManager.getLogManager();
        logManager.reset();

        // log file max size 10K, 3 rolling files, append-on-open
        Handler fileHandler;
		try {
			fileHandler = new FileHandler("log", 10000, 3, true);
			fileHandler.setFormatter(new SimpleFormatter());
	        Logger.getLogger("").addHandler(fileHandler); 
			
			// preserve old stdout/stderr streams in case they might be useful
	    	PrintStream stdout = System.out;
	    	PrintStream stderr = System.err;
	    	
	    	// now rebind stdout/stderr to logger
	    	Logger logger;
	    	LoggingOutputStream los;

	    	logger = Logger.getLogger("stdout");
	    	los = new LoggingOutputStream(logger, StdOutErrLevel.STDOUT);
	    	System.setOut(new PrintStream(los, true));
	    	
	    	logger = Logger.getLogger("stderr");
	    	los= new LoggingOutputStream(logger, StdOutErrLevel.STDERR);
	    	System.setErr(new PrintStream(los, true));
	        
	    } catch (SecurityException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		
        initUI();                            
	
	}

	public final void initUI() {

		panel = new JPanel();

		getContentPane().add(panel);
		panel.setLayout(null);
		setTitle("T-Nano");
		
		Toolkit tk = Toolkit.getDefaultToolkit(); 
		
		fullSizeWidth = ((int) tk.getScreenSize().getWidth());  
		fullSizeHeight = ((int) tk.getScreenSize().getHeight());
		
		width = fullSizeWidth;
		height = fullSizeHeight;
		
		setSize(2*fullSizeWidth/3, 2*fullSizeHeight/3);
		setExtendedState(JFrame.MAXIMIZED_BOTH); 
		
		crt = 0;
		x = true;
		guiList.add(new Gui());
		
		pasteInputs = new ArrayList<Object>();
		pasteOutputs = new ArrayList<Object>();
		
		setLocationRelativeTo(null);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
	}
	
	

	public static void main(String[] args) {
		
		Main ex = new Main();	
		
		while (!quit ) {

			width = ex.getSize().width;
			height = ex.getSize().height;
			
			if(crt >= 0)
			{
				if(x)
				{
					System.out.println("Task changed");
					ex.getContentPane().removeAll();
					ex.getContentPane().add(guiList.get(crt));
					ex.setVisible(true);
					x = false;
				}
				guiList.get(crt).update();
			}
					
			try {
				Thread.sleep(50);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
			
		}
	}

	/**
	 * function which decides what has to be done
	 * depending on the actions of the user
	 */
	@Override
	public void actionPerformed(ActionEvent e) {
	}

	
	
}
