/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.io.ByteArrayOutputStream; 
import java.io.IOException; 
import java.util.logging.Level; 
import java.util.logging.Logger; 
 
/**
 * 
 * @author Daniel Pletea
 *
 */
class LoggingOutputStream extends ByteArrayOutputStream { 
 
    private String lineSeparator; 
 
    private Logger logger; 
    private Level level; 
 
    public LoggingOutputStream(Logger logger, Level level) { 
        super(); 
        this.logger = logger; 
        this.level = level; 
        lineSeparator = System.getProperty("line.separator"); 
    } 
 
    public void flush() throws IOException { 
 
        String record; 
        synchronized(this) { 
            super.flush(); 
            record = this.toString(); 
            super.reset(); 
 
            if (record.length() == 0 || record.equals(lineSeparator)) { 
                // avoid empty records 
                return; 
            } 
 
            logger.logp(level, "", "", record); 
        } 
    } 
} 
