/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
 */

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

/**
 * this class is a window dialog for asking the user about the name of the IO he
 * wants to insert
 * 
 * @author Daniel Pletea
 * 
 */
public class IODialog extends JDialog implements ActionListener, Definitions {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// the boolean variable which is true when the input from the user is
	// correct
	private boolean approve;

	// the JComponents used for this dialog window
	private JButton submitCreatedIO, submitNewIO;
	private JComboBox createdIOCombo;
	private JTextField newIOTextField;
	private JLabel message;

	private List<Object> returnList;

	public IODialog(String type, List<String> names) {

		JLabel l;
		Singleton singleton = Singleton.getInstance();

		//
		setLayout(null);

		//
		l = singleton.createLabel("Choose from created " + type + "s:  ", 50,
				50, 200, 20, null, this);
		l.setHorizontalAlignment(SwingConstants.RIGHT);

		l = singleton.createLabel("Create a new " + type + ":  ", 50, 130, 200,
				20, null, this);
		l.setHorizontalAlignment(SwingConstants.RIGHT);

		// these are the IOs from the user
		createdIOCombo = singleton.createComboBox(250, 50, 200, 20, this);
		for (int i = 0; i < names.size(); i++)
			createdIOCombo.addItem(names.get(i));
		newIOTextField = singleton.createTextField(10, 250, 130, 200, 20, this);

		// the buttons a button for every choice
		submitCreatedIO = singleton.createButton("Submit", 200, 80, 100, 20,
				this, this);
		submitNewIO = singleton.createButton("Submit", 200, 160, 100, 20, this,
				this);

		// the message for the user
		message = singleton.createLabel("Inserting", 150, 200, 200, 20,
				MESSAGE_COLOR, this);

		// set the size of the dialog window
		setPreferredSize(new Dimension(500, 300));
		setBounds(Main.fullSizeWidth / 2 - 250, Main.fullSizeHeight / 2 - 150,
				500, 300);

		approve = false;
		setModal(true); // will wait until dispose() before exiting
	}

	/**
	 * this functions returns the input from the user
	 * 
	 * @return
	 */
	public List<Object> getData() {
		return returnList;
	}

	/**
	 * this functions tells if the input from the user is valid
	 * 
	 * @return
	 */
	public boolean hasData() {
		return approve;
	}

	@Override
	public void actionPerformed(ActionEvent e) {

		// if is submitted an IO from the created IOS
		if (e.getSource().equals(submitCreatedIO)) {

			// populate the return list
			returnList = new ArrayList<Object>();
			returnList.add(CREATED_IO);
			returnList.add(createdIOCombo.getSelectedIndex());
			approve = true;
			dispose();

		} else if (e.getSource().equals(submitNewIO)) {

			// populate the return list
			returnList = new ArrayList<Object>();
			returnList.add(NEW_IO);
			if (newIOTextField.getText().length() < 1)
				message.setText("The input data is not correct");
			else if (newIOTextField.getText().length() > 3)
				message.setText("The text must have maximum 3 characters");
			else {
				returnList.add(newIOTextField.getText());
				dispose();
				approve = true;
			}
		}
	}
}
