/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.awt.Color;
import java.awt.event.MouseEvent;

/**
 * An interface with some constants
 * 
 * @author Daniel Pletea
 * 
 */
public interface Definitions {

	// nr of tiles
	public final static int NR_TILES = 21;
	public final static int NR_BASIC_TILES = 15;

	// left click
	public final static int LEFT_CLICK = MouseEvent.BUTTON1;

	// right click
	public final static int RIGHT_CLICK = MouseEvent.BUTTON2;

	// flags that indicates if an interchange is between te X coordinates or Y
	public final static char X = 0;
	public final static char Y = 1;

	// the states of the status of a circuit
	public final static char NEW = 0;
	public final static char MODIFIED = 1;
	public final static char SAVED = 2;

	// the background color
	public final static Color BACKGROUND_COLOR = Color.DARK_GRAY;

	// different color used in the program
	public final static Color SELECT_COLOR = Color.BLUE;
	public final static Color OVER_TILE_COLOR = Color.RED;
	public final static Color ARROW_COLOR = Color.YELLOW;
	public final static Color MESSAGE_COLOR = Color.RED;

	// the dim of the Wire and of the border of the tiles
	public final static int WIRE_DIM = 15;
	public final static int BORDER_TILE_DIM = 2;

	// flags for a part of the tiles
	public final static int P_TILE = 1;
	public final static int N_TILE = 2;
	public final static int VCC_TILE = 15;
	public final static int VDD_TILE = 16;
	public final static int INPUT_TILE = 17;
	public final static int OUTPUT_TILE = 18;

	// constants for the operation of creating images which have text inside
	public final static int IMAGE_DIMENSION = 200;
	public final static int MAX_NR_CHAR_INPUT = 3;
	public final static int FONT_SIZE = 72;
	public final static int CHAR_WIDTH = 50;

	// flags for created or new inputs or outputs
	public final static int CREATED_IO = 0;
	public final static int NEW_IO = 1;
	
	// zoom constants
	public final static int DELTA = 3;
	public final static int MIN_TILE_DIM = 10;
	public final static int MAX_TILE_DIM = 200;
	
	// files
	public final static String ANALYZE_FILE = "anlz";
	public final static String SIMULATION_FILE = "sim";
	public final static String PROGRESS_FILE = "prg";
	
}
