/*
	Copyright 2011 Daniel Pletea

	This file is part of T-Nano.

	T-Nano is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	T-Nano is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with T-Nano.  If not, see <http://www.gnu.org/licenses/>.
*/

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;

/**
 * class that creates a dialog with the user here are introduced the parameters
 * for the analyze part
 * 
 * @author Daniel Pletea 
 *	
 */

public class AnalyzeDialog extends JDialog implements ActionListener,
		Definitions {

	//
	private static final long serialVersionUID = 1L;

	// more textField for every parameter
	private List<JTextField> textFields;

	// the button that starts the analyzing action
	private JButton analyzeButton;

	// in this string are put all the parameters
	private String parameters;

	// a boolean variable which indicates if every parameters is a string
	// with length > 1
	private boolean approve;

	// this is a label which gives the user feedback for the input data
	private JLabel message;

	/**
	 * constructor
	 * 
	 * @param nrParameters
	 */
	public AnalyzeDialog(int nrParameters) {

		JLabel l;
		Singleton singleton = Singleton.getInstance();

		// a panel
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setPreferredSize(new Dimension(450, 100 + nrParameters * 30));

		// labels for each parameter
		for (int i = 0; i < nrParameters; i++) {
			String labelName;
			if (i == 0)
				labelName = "Output : ";
			else
				labelName = "Parameter " + (i + 2) + " :  ";
			l = singleton.createLabel(labelName, 50, 30 + i * 30, 200, 20,
					null, panel);
			l.setHorizontalAlignment(SwingConstants.RIGHT);
		}

		// the textfield are created here
		textFields = new ArrayList<JTextField>();
		for (int i = 0; i < nrParameters; i++) {
			JTextField t = singleton.createTextField(10, 250, 30 + i * 30, 100,
					20, panel);
			textFields.add(t);
		}

		// the button is created here
		analyzeButton = singleton.createButton("Submit", 200,
				30 + nrParameters * 30, 100, 20, panel, this);

		// also the label message is created
		message = Singleton.getInstance().createLabel("", 50,
				60 + nrParameters * 30, 200, 20, MESSAGE_COLOR, panel);

		// in the end a scroll option is put on the panel
		JScrollPane scrollBar = new JScrollPane(panel);
		scrollBar
				.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
		this.add(scrollBar);

		// setting dimensions
		setPreferredSize(new Dimension(500, 300));
		setBounds(Main.fullSizeWidth / 2 - 250, Main.fullSizeHeight / 2 - 150,
				500, 300);

		approve = false;
		setModal(true); // will wait until dispose() before exiting

	}

	/**
	 * return the data in the textFields
	 * 
	 * @return
	 */
	public String getData() {
		return parameters;
	}

	/**
	 * indicates if the input data is ok
	 * 
	 * @return
	 */
	public boolean hasData() {
		return approve;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(analyzeButton)) {
			parameters = "";
			boolean error = false;

			// creating the string parameters with
			// the text from the textFields
			for (int i = 0; i < textFields.size(); i++) {
				if (textFields.get(i).getText().length() < 1) {
					error = true;
					break;
				}
				parameters += textFields.get(i).getText();
				parameters += " ";
			}

			if (!error) {
				approve = true;
				dispose();
			} else
				message.setText("The input data is not correct"); // the error
																	// message
		}
	}
}
